/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.bean.appearance;

import cfca.sadk.com.itextpdf.io.image.ImageData;
import cfca.sadk.com.itextpdf.io.image.ImageDataFactory;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.BytesUtil;
import cfca.sadk.system.SADKDebugger;
import java.io.IOException;

public class GraphicAppearance
extends AbstractAppearance {
    public static final String svgImage = "<svg";
    public static final String svgImagePostFix = "</svg>";
    private boolean isSupportImageType = false;
    private byte[] stamperSr;
    private int startPageNum;
    private int endPageNum;
    private int[] pageArray = null;
    private String imageFormat;
    private ImageData imageData = null;
    private boolean isCenterCoordinate = false;
    private int crossPageStyle = 4;
    private int crossPageRangeOption = 0;
    private boolean isSVGImage = false;
    private int dpi = 0;
    private boolean isMoveCrossPosition = false;
    private boolean isAddImage = false;
    private int imageScale = 0;
    private float crossSignOffsetX = 0.0f;
    private float crossSignOffsetY = 0.0f;
    private boolean isPageRange = false;

    public int getCrossPageRangeOption() {
        return this.crossPageRangeOption;
    }

    public void setCrossPageRangeOption(int crossPageRangeOption) {
        this.crossPageRangeOption = crossPageRangeOption;
    }

    @Override
    public byte[] getStamperSr() {
        return this.stamperSr;
    }

    public void setCrossPageStyle(int crossPageStyle) {
        this.crossPageStyle = crossPageStyle;
    }

    public int getCrossPageStyle() {
        return this.crossPageStyle;
    }

    public void setStamperSr(byte[] stamperSr) throws IOException, SealException {
        this.stamperSr = stamperSr;
        if (null != stamperSr) {
            this.isSupportImageType = ImageDataFactory.isSupportedType(stamperSr);
            if (this.isSupportImageType) {
                this.imageData = ImageDataFactory.create(stamperSr);
                this.isSVGImage = false;
            } else if (SysEnv.isSupportSVG() && BytesUtil.isContainsBytes(stamperSr, svgImage.getBytes("UTF8")) && BytesUtil.isContainsBytes(stamperSr, svgImagePostFix.getBytes("UTF8"))) {
                this.isSVGImage = true;
            } else {
                throw new SealException("imageType is not support!");
            }
        }
    }

    public int getStartPageNum() {
        return this.startPageNum;
    }

    public void setStartPageNum(int startPageNum) {
        this.isPageRange = true;
        this.startPageNum = startPageNum;
    }

    public int getEndPageNum() {
        return this.endPageNum;
    }

    public void setEndPageNum(int endPageNum) {
        this.isPageRange = true;
        this.endPageNum = endPageNum;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public boolean isCenterCoordinate() {
        return this.isCenterCoordinate;
    }

    public void setCenterCoordinate() throws SealException {
        this.isCenterCoordinate = true;
        if (null == this.imageData) {
            throw new SealException("you need invoke setRectangle() before invoke setCenterCoordinate() method");
        }
        Rectangle rect = this.getRectangle();
        if (null == rect) {
            throw new SealException("you need invoke setStamperSr() before invoke setCenterCoordinate() method");
        }
        float centerX = rect.getX();
        float centerY = rect.getY();
        int xDPI = this.imageData.getDpiX() == 0 ? 96 : this.imageData.getDpiX();
        int yDPI = this.imageData.getDpiY() == 0 ? 96 : this.imageData.getDpiY();
        float width = this.imageData.getWidth() * 72.0f / (float)xDPI;
        float height = this.imageData.getHeight() * 72.0f / (float)yDPI;
        this.setRectangle(new Rectangle(centerX - width / 2.0f, centerY - height / 2.0f, width, height));
    }

    public boolean isSupportImageType() {
        return this.isSupportImageType;
    }

    @Override
    public boolean isSVGImage() {
        return this.isSVGImage;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi <= 0 ? 96 : dpi;
    }

    public boolean isMoveCrossPosition() {
        return this.isMoveCrossPosition;
    }

    public void setMoveCrossPosition(boolean isMoveCrossPosition) {
        this.isMoveCrossPosition = isMoveCrossPosition;
    }

    public boolean isAddImage() {
        return this.isAddImage;
    }

    public void setAddImage(boolean isAddImage) {
        this.isAddImage = isAddImage;
    }

    public int getImageScale() {
        return this.imageScale;
    }

    public void setImageScale(int imageScale) {
        this.imageScale = imageScale;
    }

    public float getCrossSignOffsetX() {
        return this.crossSignOffsetX;
    }

    public void setCrossSignOffsetX(float crossSignOffsetX) {
        this.crossSignOffsetX = crossSignOffsetX;
    }

    public float getCrossSignOffsetY() {
        return this.crossSignOffsetY;
    }

    public void setCrossSignOffsetY(float crossSignOffsetY) {
        this.crossSignOffsetY = crossSignOffsetY;
    }

    public int[] getPageArray() {
        return this.pageArray;
    }

    public void setPageArray(int[] pageArray) {
        this.pageArray = pageArray;
    }

    public boolean isPageRange() {
        return this.isPageRange;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("GraphicAppearance>>>>>>Running");
        buffer.append("\n stamperSr: ");
        buffer.append(SADKDebugger.dump((byte[])this.stamperSr));
        buffer.append("\n startPageNum : int: ");
        buffer.append(this.startPageNum);
        buffer.append("\n endPageNum : int:");
        buffer.append(this.endPageNum);
        buffer.append("\n  imageFormat : float:");
        buffer.append(this.imageFormat);
        return buffer.toString() + "\n" + super.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static interface SubPageRangeOption {
        public static final int ALL = 0;
        public static final int ODD = 1;
        public static final int EVEN = 2;
    }

    public static interface CrossPageStyle {
        public static final int NOT_CROSS_PAGE = 0;
        public static final int UP_DOWN_HALF = 1;
        public static final int LEFT_RIGHT_HALF = 2;
        public static final int UP_DOWN_STRIPE = 3;
        public static final int LEFT_RIGHT_STRIPE = 4;
        public static final int LEFT_STRIPE = 5;
        public static final int RIGHT_STRIPE = 6;
        public static final int UP_STRIPE = 7;
        public static final int DOWN_STRIPE = 8;
    }
}

