/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.mapper;

import io.github.autoffice.luckysheet.mapper.CellMapperToLuckySheet;
import io.github.autoffice.luckysheet.mapper.ImageMapperToLuckySheet;
import io.github.autoffice.luckysheet.mapper.LuckySheetFactory;
import io.github.autoffice.luckysheet.model.cell.CellData;
import io.github.autoffice.luckysheet.model.cell.MergeCell;
import io.github.autoffice.luckysheet.model.sheet.BoolStatus;
import io.github.autoffice.luckysheet.model.sheet.Border;
import io.github.autoffice.luckysheet.model.sheet.Frozen;
import io.github.autoffice.luckysheet.model.sheet.FrozenType;
import io.github.autoffice.luckysheet.model.sheet.LuckySheet;
import io.github.autoffice.luckysheet.model.sheet.PageMargin;
import io.github.autoffice.luckysheet.util.NumberUtil;
import io.github.autoffice.luckysheet.util.PoiUtil;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class SheetMapperToLuckySheet {
    public static void mapToSheet(XSSFSheet sheet, LuckySheet luckySheet) {
        luckySheet.setZoomRatio(1.0);
        SheetMapperToLuckySheet.mapDefaultRowHeight(sheet, luckySheet);
        SheetMapperToLuckySheet.mapDefaultColumnWidth(sheet, luckySheet);
        for (int rowIndex = PoiUtil.getFirstRowBase0((Sheet)sheet); rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            if (row == null) continue;
            for (int colIndex = row.getFirstCellNum(); colIndex < row.getLastCellNum(); ++colIndex) {
                XSSFCell cell = row.getCell(colIndex);
                if (cell == null) continue;
                CellData cellData = LuckySheetFactory.createCellData();
                cellData.setC(colIndex);
                cellData.setR(rowIndex);
                CellMapperToLuckySheet.mapToCell(cell, cellData);
                luckySheet.getCelldata().add(cellData);
                SheetMapperToLuckySheet.mapBorder(cell, luckySheet);
            }
        }
        SheetMapperToLuckySheet.mapSheetStatus(sheet, luckySheet);
        SheetMapperToLuckySheet.mapSheetHidden(sheet, luckySheet);
        SheetMapperToLuckySheet.mapMergeCell(sheet, luckySheet);
        SheetMapperToLuckySheet.mapRowHeightAndHidden(sheet, luckySheet);
        SheetMapperToLuckySheet.mapColumnWithAndHidden(sheet, luckySheet);
        SheetMapperToLuckySheet.mapGridLines(sheet, luckySheet);
        SheetMapperToLuckySheet.mapFrozen(sheet, luckySheet);
        SheetMapperToLuckySheet.mapPageMargin(sheet, luckySheet);
        ImageMapperToLuckySheet.mapToSheet(sheet, luckySheet);
    }

    private static void mapPageMargin(XSSFSheet sheet, LuckySheet luckySheet) {
        XSSFPrintSetup printSetup = sheet.getPrintSetup();
        PageMargin pageMargin = new PageMargin();
        if (printSetup != null) {
            pageMargin.setLeft(sheet.getMargin((short)0));
            pageMargin.setRight(sheet.getMargin((short)1));
            pageMargin.setTop(sheet.getMargin((short)2));
            pageMargin.setBottom(sheet.getMargin((short)3));
            pageMargin.setScale(printSetup.getScale());
            pageMargin.setLandscape(printSetup.getLandscape());
        }
        luckySheet.setPageMargin(pageMargin);
    }

    private static void mapFrozen(XSSFSheet sheet, LuckySheet luckySheet) {
        PaneInformation paneInformation = sheet.getPaneInformation();
        if (paneInformation == null || !paneInformation.isFreezePane()) {
            return;
        }
        short topRow = paneInformation.getHorizontalSplitPosition();
        short leftCol = paneInformation.getVerticalSplitPosition();
        if (topRow == 0 && leftCol == 0) {
            return;
        }
        Frozen frozen = LuckySheetFactory.createFrozen();
        if (topRow == 1 && leftCol == 0) {
            frozen.setType(FrozenType.ROW);
        } else if (topRow == 0 && leftCol == 1) {
            frozen.setType(FrozenType.COLUMN);
        } else if (topRow == 1 && leftCol == 1) {
            frozen.setType(FrozenType.BOTH);
        } else if (topRow == 0 && leftCol > 1) {
            frozen.setType(FrozenType.RANGE_COLUMN);
            frozen.setRange(new Frozen.Range(topRow, leftCol));
        } else if (topRow > 1 && leftCol == 0) {
            frozen.setType(FrozenType.RANGE_ROW);
            frozen.setRange(new Frozen.Range(topRow, leftCol));
        } else if (topRow > 1 && leftCol > 1) {
            frozen.setType(FrozenType.RANGE_BOTH);
            frozen.setRange(new Frozen.Range(topRow, leftCol));
        }
        luckySheet.setFrozen(frozen);
    }

    private static void mapGridLines(XSSFSheet sheet, LuckySheet luckySheet) {
        luckySheet.setShowGridLines(BoolStatus.of(sheet.isDisplayGridlines()));
    }

    private static void mapBorder(XSSFCell cell, LuckySheet luckySheet) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            return;
        }
        Border border = LuckySheetFactory.createBorder();
        border.getValue().setCol_index(cell.getColumnIndex());
        border.getValue().setRow_index(cell.getRowIndex());
        border.getValue().setT(LuckySheetFactory.createBorderStyle(cellStyle.getTopBorderXSSFColor(), cellStyle.getBorderTop()));
        border.getValue().setR(LuckySheetFactory.createBorderStyle(cellStyle.getRightBorderXSSFColor(), cellStyle.getBorderRight()));
        border.getValue().setB(LuckySheetFactory.createBorderStyle(cellStyle.getBottomBorderXSSFColor(), cellStyle.getBorderBottom()));
        border.getValue().setL(LuckySheetFactory.createBorderStyle(cellStyle.getLeftBorderXSSFColor(), cellStyle.getBorderLeft()));
        if (LuckySheetFactory.hasBorderStyle(border)) {
            luckySheet.getConfig().getBorderInfo().add(border);
        }
    }

    private static void mapColumnWithAndHidden(XSSFSheet sheet, LuckySheet luckySheet) {
        int maxColNum = PoiUtil.getMaxColNum((Sheet)sheet);
        for (int i = 0; i < maxColNum; ++i) {
            float columnWidthInPixels = sheet.getColumnWidthInPixels(i);
            luckySheet.getConfig().getColumnlen().put(i, Math.round(columnWidthInPixels));
            if (!sheet.isColumnHidden(i)) continue;
            luckySheet.getConfig().getColhidden().put(i, 0);
        }
    }

    private static void mapRowHeightAndHidden(XSSFSheet sheet, LuckySheet luckySheet) {
        for (int i = PoiUtil.getFirstRowBase0((Sheet)sheet); i <= sheet.getLastRowNum(); ++i) {
            XSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            luckySheet.getConfig().getRowlen().put(i, NumberUtil.twips2Pixel(row.getHeight()));
            if (!row.getZeroHeight()) continue;
            luckySheet.getConfig().getRowhidden().put(i, 0);
        }
    }

    private static void mapMergeCell(XSSFSheet sheet, LuckySheet luckySheet) {
        List mergedRegions = sheet.getMergedRegions();
        for (CellRangeAddress mergedRegion : mergedRegions) {
            MergeCell mergeCell = new MergeCell();
            mergeCell.setR(mergedRegion.getFirstRow());
            mergeCell.setRs(mergedRegion.getLastRow() - mergedRegion.getFirstRow() + 1);
            mergeCell.setC(mergedRegion.getFirstColumn());
            mergeCell.setCs(mergedRegion.getLastColumn() - mergedRegion.getFirstColumn() + 1);
            luckySheet.getConfig().getMerge().put(mergeCell.getR() + "_" + mergeCell.getC(), mergeCell);
        }
    }

    private static void mapSheetHidden(XSSFSheet sheet, LuckySheet luckySheet) {
        int sheetIndex = sheet.getWorkbook().getSheetIndex((Sheet)sheet);
        luckySheet.setHide(BoolStatus.of(sheet.getWorkbook().isSheetHidden(sheetIndex)));
    }

    private static void mapSheetStatus(XSSFSheet sheet, LuckySheet luckySheet) {
        luckySheet.setStatus(BoolStatus.of(sheet.isSelected()));
    }

    private static void mapDefaultColumnWidth(XSSFSheet sheet, LuckySheet luckySheet) {
        luckySheet.setDefaultColWidth((short)NumberUtil.characterLen2Pixel(sheet.getDefaultColumnWidth()));
    }

    private static void mapDefaultRowHeight(XSSFSheet sheet, LuckySheet luckySheet) {
        luckySheet.setDefaultRowHeight((short)NumberUtil.twips2Pixel(sheet.getDefaultRowHeight()));
    }
}

