/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat0;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat10;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat12;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat13;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat14;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat2;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat4;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat6;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat8;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CMap
extends SubTable
implements Iterable<Integer> {
    protected final int format;
    protected final CMapTable.CMapId cmapId;

    protected CMap(ReadableFontData data, int format, CMapTable.CMapId cmapId) {
        super(data);
        this.format = format;
        this.cmapId = cmapId;
    }

    public int format() {
        return this.format;
    }

    public CMapTable.CMapId cmapId() {
        return this.cmapId;
    }

    public int platformId() {
        return this.cmapId().platformId();
    }

    public int encodingId() {
        return this.cmapId().encodingId();
    }

    public int hashCode() {
        return this.cmapId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CMap)) {
            return false;
        }
        return this.cmapId.equals(((CMap)obj).cmapId);
    }

    public abstract int language();

    public abstract int glyphId(int var1);

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("cmap: ");
        builder.append(this.cmapId());
        builder.append(", ");
        builder.append((Object)CMapFormat.valueOf(this.format()));
        builder.append(", Data Size=0x");
        builder.append(Integer.toHexString(this.data.length()));
        return builder.toString();
    }

    public static abstract class Builder<T extends CMap>
    extends SubTable.Builder<T> {
        private final CMapFormat format;
        private final CMapTable.CMapId cmapId;
        private int language;

        protected Builder(ReadableFontData data, CMapFormat format, CMapTable.CMapId cmapId) {
            super(data);
            this.format = format;
            this.cmapId = cmapId;
        }

        public CMapTable.CMapId cmapId() {
            return this.cmapId;
        }

        public int encodingId() {
            return this.cmapId().encodingId();
        }

        public int platformId() {
            return this.cmapId().platformId();
        }

        public CMapFormat format() {
            return this.format;
        }

        public int language() {
            return this.language;
        }

        public void setLanguage(int language) {
            this.language = language;
        }

        protected Builder(WritableFontData data, CMapFormat format, CMapTable.CMapId cmapId) {
            super(data);
            this.format = format;
            this.cmapId = cmapId;
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return this.internalReadData().length();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            return this.internalReadData().copyTo(newData);
        }

        static Builder<? extends CMap> getBuilder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            int rawFormat = data.readUShort(offset);
            CMapFormat format = CMapFormat.valueOf(rawFormat);
            switch (format) {
                case Format0: {
                    return new CMapFormat0.Builder(data, offset, cmapId);
                }
                case Format2: {
                    return new CMapFormat2.Builder(data, offset, cmapId);
                }
                case Format4: {
                    return new CMapFormat4.Builder(data, offset, cmapId);
                }
                case Format6: {
                    return new CMapFormat6.Builder(data, offset, cmapId);
                }
                case Format8: {
                    return new CMapFormat8.Builder(data, offset, cmapId);
                }
                case Format10: {
                    return new CMapFormat10.Builder(data, offset, cmapId);
                }
                case Format12: {
                    return new CMapFormat12.Builder(data, offset, cmapId);
                }
                case Format13: {
                    return new CMapFormat13.Builder(data, offset, cmapId);
                }
                case Format14: {
                    return new CMapFormat14.Builder(data, offset, cmapId);
                }
            }
            return null;
        }

        static Builder<? extends CMap> getBuilder(CMapFormat cmapFormat, CMapTable.CMapId cmapId) {
            switch (cmapFormat) {
                case Format0: {
                    return new CMapFormat0.Builder(null, 0, cmapId);
                }
                case Format4: {
                    return new CMapFormat4.Builder(null, 0, cmapId);
                }
                case Format12: {
                    return new CMapFormat12.Builder(null, 0, cmapId);
                }
            }
            return null;
        }

        public String toString() {
            return String.format("%s, format = %s", new Object[]{this.cmapId(), this.format()});
        }
    }

    protected class CharacterIterator
    implements Iterator<Integer> {
        private int character = 0;
        private final int maxCharacter;

        CharacterIterator(int start, int end) {
            this.character = start;
            this.maxCharacter = end;
        }

        @Override
        public boolean hasNext() {
            return this.character < this.maxCharacter;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            return this.character++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }

    public static enum CMapFormat {
        Format0(0),
        Format2(2),
        Format4(4),
        Format6(6),
        Format8(8),
        Format10(10),
        Format12(12),
        Format13(13),
        Format14(14);

        final int value;

        private CMapFormat(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static CMapFormat valueOf(int value) {
            for (CMapFormat format : CMapFormat.values()) {
                if (!format.equals(value)) continue;
                return format;
            }
            return null;
        }
    }
}

