/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font;

import cfca.sadk.com.itextpdf.io.IOException;
import cfca.sadk.com.itextpdf.io.font.AdobeGlyphList;
import cfca.sadk.com.itextpdf.io.font.FontConstants;
import cfca.sadk.com.itextpdf.io.font.FontNames;
import cfca.sadk.com.itextpdf.io.font.FontProgram;
import cfca.sadk.com.itextpdf.io.font.Type1Parser;
import cfca.sadk.com.itextpdf.io.font.otf.Glyph;
import cfca.sadk.com.itextpdf.io.source.RandomAccessFileOrArray;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type1Font
extends FontProgram {
    private static final long serialVersionUID = -1078208220942939920L;
    private Type1Parser fontParser;
    private String characterSet;
    private Map<Long, Integer> kernPairs = new HashMap<Long, Integer>();
    private static final int[] PFB_TYPES = new int[]{1, 2, 1};
    private byte[] fontStreamBytes;
    private int[] fontStreamLengths;

    protected static Type1Font createStandardFont(String name) throws java.io.IOException {
        if (FontConstants.BUILTIN_FONTS_14.contains(name)) {
            return new Type1Font(name, null, null, null);
        }
        throw new IOException("1.is.not.a.standard.type1.font").setMessageParams(name);
    }

    protected Type1Font() {
        this.fontNames = new FontNames();
    }

    protected Type1Font(String metricsPath, String binaryPath, byte[] afm, byte[] pfb) throws java.io.IOException {
        this();
        this.checkFilePath(metricsPath);
        this.checkFilePath(binaryPath);
        this.fontParser = new Type1Parser(metricsPath, binaryPath, afm, pfb);
        this.process();
    }

    protected Type1Font(String baseFont) {
        this();
        this.getFontNames().setFontName(baseFont);
    }

    public boolean isBuiltInFont() {
        return this.fontParser != null && this.fontParser.isBuiltInFont();
    }

    @Override
    public int getPdfFontFlags() {
        int flags = 0;
        if (this.fontMetrics.isFixedPitch()) {
            flags |= 1;
        }
        flags |= this.isFontSpecific() ? 4 : 32;
        if (this.fontMetrics.getItalicAngle() < 0.0f) {
            flags |= 0x40;
        }
        if (this.fontNames.getFontName().contains("Caps") || this.fontNames.getFontName().endsWith("SC")) {
            flags |= 0x20000;
        }
        if (this.fontNames.isBold() || this.fontNames.getFontWeight() > 500) {
            flags |= 0x40000;
        }
        return flags;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    @Override
    public boolean hasKernPairs() {
        return this.kernPairs.size() > 0;
    }

    @Override
    public int getKerning(Glyph first, Glyph second) {
        if (first.hasValidUnicode() && second.hasValidUnicode()) {
            long record = ((long)first.getUnicode() << 32) + (long)second.getUnicode();
            if (this.kernPairs.containsKey(record)) {
                return this.kernPairs.get(record);
            }
            return 0;
        }
        return 0;
    }

    public boolean setKerning(int first, int second, int kern) {
        long record = ((long)first << 32) + (long)second;
        this.kernPairs.put(record, kern);
        return true;
    }

    public Glyph getGlyph(String name) {
        int unicode = AdobeGlyphList.nameToUnicode(name);
        if (unicode != -1) {
            return this.getGlyph(unicode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFontStreamBytes() {
        if (this.fontParser.isBuiltInFont()) {
            return null;
        }
        if (this.fontStreamBytes != null) {
            return this.fontStreamBytes;
        }
        RandomAccessFileOrArray raf = null;
        try {
            raf = this.fontParser.getPostscriptBinary();
            int fileLength = (int)raf.length();
            this.fontStreamBytes = new byte[fileLength - 18];
            this.fontStreamLengths = new int[3];
            int bytePtr = 0;
            int k = 0;
            while (true) {
                int size;
                if (k < 3) {
                    if (raf.read() != 128) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("Start marker is missing in the pfb file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    if (raf.read() != PFB_TYPES[k]) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("incorrect.segment.type.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    size = raf.read();
                    size += raf.read() << 8;
                    size += raf.read() << 16;
                    this.fontStreamLengths[k] = size += raf.read() << 24;
                } else {
                    byte[] byArray = this.fontStreamBytes;
                    return byArray;
                }
                while (size != 0) {
                    int got = raf.read(this.fontStreamBytes, bytePtr, size);
                    if (got < 0) {
                        Logger logger = LoggerFactory.getLogger(Type1Font.class);
                        logger.error("premature.end.in.pfb.file");
                        byte[] byArray = null;
                        return byArray;
                    }
                    bytePtr += got;
                    size -= got;
                }
                ++k;
            }
        }
        catch (Exception e) {
            Logger logger = LoggerFactory.getLogger(Type1Font.class);
            logger.error("type1.font.file.exception");
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int[] getFontStreamLengths() {
        return this.fontStreamLengths;
    }

    protected void process() throws java.io.IOException {
        Glyph space;
        String line;
        RandomAccessFileOrArray raf = this.fontParser.getMetricsFile();
        boolean startKernPairs = false;
        while (!startKernPairs && (line = raf.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, " ,\n\r\t\f");
            if (!tok.hasMoreTokens()) continue;
            String ident = tok.nextToken();
            if ("FontName".equals(ident)) {
                this.fontNames.setFontName(tok.nextToken("\u00ff").substring(1));
                continue;
            }
            if ("FullName".equals(ident)) {
                String fullName = tok.nextToken("\u00ff").substring(1);
                this.fontNames.setFullName(new String[][]{{"", "", "", fullName}});
                continue;
            }
            if ("FamilyName".equals(ident)) {
                String familyName = tok.nextToken("\u00ff").substring(1);
                this.fontNames.setFamilyName(new String[][]{{"", "", "", familyName}});
                continue;
            }
            if ("Weight".equals(ident)) {
                this.fontNames.setWeight(FontNames.convertFontWeight(tok.nextToken("\u00ff").substring(1)));
                continue;
            }
            if ("ItalicAngle".equals(ident)) {
                this.fontMetrics.setItalicAngle(Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("IsFixedPitch".equals(ident)) {
                this.fontMetrics.setIsFixedPitch(tok.nextToken().equals("true"));
                continue;
            }
            if ("CharacterSet".equals(ident)) {
                this.characterSet = tok.nextToken("\u00ff").substring(1);
                continue;
            }
            if ("FontBBox".equals(ident)) {
                int llx = (int)Float.parseFloat(tok.nextToken());
                int lly = (int)Float.parseFloat(tok.nextToken());
                int urx = (int)Float.parseFloat(tok.nextToken());
                int ury = (int)Float.parseFloat(tok.nextToken());
                this.fontMetrics.setBbox(llx, lly, urx, ury);
                continue;
            }
            if ("UnderlinePosition".equals(ident)) {
                this.fontMetrics.setUnderlinePosition((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("UnderlineThickness".equals(ident)) {
                this.fontMetrics.setUnderlineThickness((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("EncodingScheme".equals(ident)) {
                this.encodingScheme = tok.nextToken("\u00ff").substring(1).trim();
                continue;
            }
            if ("CapHeight".equals(ident)) {
                this.fontMetrics.setCapHeight((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("XHeight".equals(ident)) {
                this.fontMetrics.setXHeight((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("Ascender".equals(ident)) {
                this.fontMetrics.setTypoAscender((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("Descender".equals(ident)) {
                this.fontMetrics.setTypoDescender((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("StdHW".equals(ident)) {
                this.fontMetrics.setStemH((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if ("StdVW".equals(ident)) {
                this.fontMetrics.setStemV((int)Float.parseFloat(tok.nextToken()));
                continue;
            }
            if (!"StartCharMetrics".equals(ident)) continue;
            startKernPairs = true;
        }
        if (!startKernPairs) {
            String metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.startcharmetrics.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.startcharmetrics.in.the.metrics.file");
        }
        this.avgWidth = 0;
        int widthCount = 0;
        while ((line = raf.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            String ident = tok.nextToken();
            if (ident.equals("EndCharMetrics")) {
                startKernPairs = false;
                break;
            }
            int C = -1;
            int WX = 250;
            String N = "";
            int[] B = null;
            tok = new StringTokenizer(line, ";");
            while (tok.hasMoreTokens()) {
                StringTokenizer tokc = new StringTokenizer(tok.nextToken());
                if (!tokc.hasMoreTokens()) continue;
                ident = tokc.nextToken();
                if ("C".equals(ident)) {
                    C = Integer.parseInt(tokc.nextToken());
                    continue;
                }
                if ("WX".equals(ident)) {
                    WX = (int)Float.parseFloat(tokc.nextToken());
                    continue;
                }
                if ("N".equals(ident)) {
                    N = tokc.nextToken();
                    continue;
                }
                if (!"B".equals(ident)) continue;
                B = new int[]{Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken()), Integer.parseInt(tokc.nextToken())};
            }
            int unicode = AdobeGlyphList.nameToUnicode(N);
            Glyph glyph = new Glyph(C, WX, unicode, B);
            if (C >= 0) {
                this.codeToGlyph.put(C, glyph);
            }
            if (unicode != -1) {
                this.unicodeToGlyph.put(unicode, glyph);
            }
            this.avgWidth += WX;
            ++widthCount;
        }
        if (widthCount != 0) {
            this.avgWidth /= widthCount;
        }
        if (startKernPairs) {
            String metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.endcharmetrics.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.endcharmetrics.in.the.metrics.file");
        }
        if (!this.unicodeToGlyph.containsKey(160) && (space = (Glyph)this.unicodeToGlyph.get(32)) != null) {
            this.unicodeToGlyph.put(160, new Glyph(space.getCode(), space.getWidth(), 160, space.getBbox()));
        }
        boolean endOfMetrics = false;
        while ((line = raf.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line);
            if (!tok.hasMoreTokens()) continue;
            String ident = tok.nextToken();
            if (ident.equals("EndFontMetrics")) {
                endOfMetrics = true;
                break;
            }
            if (!ident.equals("StartKernPairs")) continue;
            startKernPairs = true;
            break;
        }
        if (startKernPairs) {
            while ((line = raf.readLine()) != null) {
                StringTokenizer tok = new StringTokenizer(line);
                if (!tok.hasMoreTokens()) continue;
                String ident = tok.nextToken();
                if (ident.equals("KPX")) {
                    String first = tok.nextToken();
                    String second = tok.nextToken();
                    Integer width = (int)Float.parseFloat(tok.nextToken());
                    int firstUni = AdobeGlyphList.nameToUnicode(first);
                    int secondUni = AdobeGlyphList.nameToUnicode(second);
                    if (firstUni == -1 || secondUni == -1) continue;
                    long record = ((long)firstUni << 32) + (long)secondUni;
                    this.kernPairs.put(record, width);
                    continue;
                }
                if (!ident.equals("EndKernPairs")) continue;
                startKernPairs = false;
                break;
            }
        } else if (!endOfMetrics) {
            String metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.endfontmetrics.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.endfontmetrics.in.the.metrics.file");
        }
        if (startKernPairs) {
            String metricsPath = this.fontParser.getAfmPath();
            if (metricsPath != null) {
                throw new IOException("missing.endkernpairs.in.1").setMessageParams(metricsPath);
            }
            throw new IOException("missing.endkernpairs.in.the.metrics.file");
        }
        raf.close();
        this.isFontSpecific = !this.encodingScheme.equals("AdobeStandardEncoding") && !this.encodingScheme.equals("StandardEncoding");
    }
}

