/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import java.io.File;

public abstract class Assert {
    public static void notNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is required; it must not be null");
        }
    }

    public static void notEmpty(byte[] sourceData, String message) {
        if (sourceData == null || sourceData.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasFileLength(String filePath) {
        Assert.notNull(filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("checkFileExist failure: not found " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("checkFileExist failure: not file " + file.getAbsolutePath());
        }
        if (file.length() <= 0L) {
            throw new IllegalArgumentException("file length is 0L");
        }
    }
}

