/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import cfca.sadk.tls.util.DataHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

public final class SignatureAlgorithmsExtension
extends HelloExtension {
    private List<SignatureAndHashAlgorithm> algorithms;

    public SignatureAlgorithmsExtension(Collection<SignatureAndHashAlgorithm> signAlgs) {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>(signAlgs);
    }

    SignatureAlgorithmsExtension(HandshakeInStream in, int len) throws IOException {
        super(ExtensionType.EXT_SIGNATURE_ALGORITHMS);
        int remains;
        int algorithmsLen = in.getInt16();
        if (algorithmsLen == 0 || algorithmsLen + 2 != len) {
            throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
        }
        this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
        int sequence = 0;
        for (remains = algorithmsLen; remains > 1; remains -= 2) {
            int hash = in.getInt8();
            int signature = in.getInt8();
            this.algorithms.add(SignatureAndHashAlgorithm.valueOf(hash, signature, ++sequence));
        }
        if (remains != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    public Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
        return this.algorithms;
    }

    @Override
    final int length() {
        return 6 + SignatureAndHashAlgorithm.sizeInRecord() * this.algorithms.size();
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        int dataLength = encoded.length - 6;
        DataHelper.write((short)this.type.id, encoded, 0);
        DataHelper.write((short)(dataLength + 2), encoded, 2);
        DataHelper.write((short)dataLength, encoded, 4);
        int offset = 6;
        for (SignatureAndHashAlgorithm algorithm : this.algorithms) {
            DataHelper.write((byte)algorithm.getHashValue(), encoded, offset++);
            DataHelper.write((byte)algorithm.getSignatureValue(), encoded, offset++);
        }
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", signature_algorithms: ");
        boolean opened = false;
        for (SignatureAndHashAlgorithm signAlg : this.algorithms) {
            if (opened) {
                builder.append(", ");
            } else {
                opened = true;
            }
            builder.append(signAlg.getAlgorithmName());
        }
        return builder.toString();
    }
}

