/*
 * Decompiled with CFR 0.152.
 */
package io.github.autoffice.luckysheet.model.cell;

import com.fasterxml.jackson.annotation.JsonValue;
import io.github.autoffice.luckysheet.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public enum CellVerticalType {
    CENTER(0, VerticalAlignment.CENTER),
    TOP(1, VerticalAlignment.TOP),
    BOTTOM(2, VerticalAlignment.BOTTOM);

    @JsonValue
    private final Integer lsValue;
    private final VerticalAlignment poiValue;
    private static final Map<VerticalAlignment, CellVerticalType> TYPES;

    public static CellVerticalType of(VerticalAlignment verticalAlignment) {
        CellVerticalType cellVerticalType = TYPES.get(verticalAlignment);
        return Util.requireNonNullElse(cellVerticalType, CENTER);
    }

    @Generated
    private CellVerticalType(Integer lsValue, VerticalAlignment poiValue) {
        this.lsValue = lsValue;
        this.poiValue = poiValue;
    }

    @Generated
    public VerticalAlignment getPoiValue() {
        return this.poiValue;
    }

    static {
        TYPES = Arrays.stream(CellVerticalType.values()).collect(Collectors.toMap(CellVerticalType::getPoiValue, Function.identity()));
    }
}

