/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.sfnttool;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.FontFactory;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.com.google.typography.font.tools.conversion.eot.EOTWriter;
import cfca.com.google.typography.font.tools.conversion.woff.WoffWriter;
import cfca.com.google.typography.font.tools.sfnttool.GlyphCoverage;
import cfca.com.google.typography.font.tools.subsetter.HintStripper;
import cfca.com.google.typography.font.tools.subsetter.RenumberingSubsetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SfntTool {
    private boolean strip = false;
    private String subsetString = null;
    private boolean woff = false;
    private boolean eot = false;
    private boolean mtx = false;

    private static final void printUsage() {
        System.out.println("Subset [-?|-h|-help] [-b] [-s string] fontfile outfile");
        System.out.println("Prototype font subsetter");
        System.out.println("\t-?,-help\tprint this help information");
        System.out.println("\t-s,-string\t String to subset");
        System.out.println("\t-b,-bench\t Benchmark (run 10000 iterations)");
        System.out.println("\t-h,-hints\t Strip hints");
        System.out.println("\t-w,-woff\t Output WOFF format");
        System.out.println("\t-e,-eot\t Output EOT format");
        System.out.println("\t-x,-mtx\t Enable Microtype Express compression for EOT format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subsetFontFile(File fontFile, File outputFile, int nIters) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fontFile);
            byte[] fontBytes = new byte[(int)fontFile.length()];
            fis.read(fontBytes);
            Font[] fontArray = null;
            fontArray = fontFactory.loadFonts(fontBytes);
            Font font = fontArray[0];
            ArrayList<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
            cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
            cmapIds.add(CMapTable.CMapId.WINDOWS_UCS4);
            for (int i = 0; i < nIters; ++i) {
                Font newFont = font;
                if (this.subsetString != null) {
                    RenumberingSubsetter subsetter = new RenumberingSubsetter(newFont, fontFactory);
                    subsetter.setCMaps(cmapIds, cmapIds.size());
                    HashMap<String, List<Integer>> resultMap = GlyphCoverage.getGlyphCoverage(font, this.subsetString);
                    List<Integer> glyphs = resultMap.get("sortedGlyphs");
                    subsetter.setGlyphs(glyphs);
                    HashSet<Integer> removeTables = new HashSet<Integer>();
                    removeTables.add(Tag.GDEF);
                    removeTables.add(Tag.GPOS);
                    removeTables.add(Tag.GSUB);
                    removeTables.add(Tag.kern);
                    removeTables.add(Tag.hdmx);
                    removeTables.add(Tag.vmtx);
                    removeTables.add(Tag.VDMX);
                    removeTables.add(Tag.LTSH);
                    removeTables.add(Tag.DSIG);
                    removeTables.add(Tag.vhea);
                    removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                    removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                    subsetter.setRemoveTables(removeTables);
                    newFont = subsetter.subset().build();
                }
                if (this.strip) {
                    HintStripper hintStripper = new HintStripper(newFont, fontFactory);
                    HashSet<Integer> removeTables = new HashSet<Integer>();
                    removeTables.add(Tag.fpgm);
                    removeTables.add(Tag.prep);
                    removeTables.add(Tag.cvt);
                    removeTables.add(Tag.hdmx);
                    removeTables.add(Tag.VDMX);
                    removeTables.add(Tag.LTSH);
                    removeTables.add(Tag.DSIG);
                    removeTables.add(Tag.vhea);
                    hintStripper.setRemoveTables(removeTables);
                    newFont = hintStripper.subset().build();
                }
                FileOutputStream fos = new FileOutputStream(outputFile);
                if (this.woff) {
                    WritableFontData woffData = new WoffWriter().convert(newFont);
                    woffData.copyTo(fos);
                    continue;
                }
                if (this.eot) {
                    WritableFontData eotData = new EOTWriter(this.mtx).convert(newFont);
                    eotData.copyTo(fos);
                    continue;
                }
                fontFactory.serializeFont(newFont, fos);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, List<Integer>> subsetFontFile(Font font, OutputStream outputStream) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        HashMap<String, List<Integer>> resultMap = null;
        try {
            ArrayList<CMapTable.CMapId> cmapIds = new ArrayList<CMapTable.CMapId>();
            cmapIds.add(CMapTable.CMapId.WINDOWS_BMP);
            cmapIds.add(CMapTable.CMapId.WINDOWS_UCS4);
            Font newFont = font;
            if (this.subsetString != null) {
                RenumberingSubsetter subsetter = new RenumberingSubsetter(newFont, fontFactory);
                subsetter.setCMaps(cmapIds, cmapIds.size());
                resultMap = GlyphCoverage.getGlyphCoverage(font, this.subsetString);
                List<Integer> glyphs = resultMap.get("sortedGlyphs");
                subsetter.setGlyphs(glyphs);
                HashSet<Integer> removeTables = new HashSet<Integer>();
                removeTables.add(Tag.GDEF);
                removeTables.add(Tag.GPOS);
                removeTables.add(Tag.GSUB);
                removeTables.add(Tag.kern);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.vmtx);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.DSIG);
                removeTables.add(Tag.vhea);
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 116}));
                removeTables.add(Tag.intValue(new byte[]{109, 111, 114, 120}));
                subsetter.setRemoveTables(removeTables);
                newFont = subsetter.subset().build();
            }
            if (this.strip) {
                HintStripper hintStripper = new HintStripper(newFont, fontFactory);
                HashSet<Integer> removeTables = new HashSet<Integer>();
                removeTables.add(Tag.fpgm);
                removeTables.add(Tag.prep);
                removeTables.add(Tag.cvt);
                removeTables.add(Tag.hdmx);
                removeTables.add(Tag.VDMX);
                removeTables.add(Tag.LTSH);
                removeTables.add(Tag.DSIG);
                removeTables.add(Tag.vhea);
                hintStripper.setRemoveTables(removeTables);
                newFont = hintStripper.subset().build();
            }
            if (this.woff) {
                WritableFontData woffData = new WoffWriter().convert(newFont);
                woffData.copyTo(outputStream);
            } else if (this.eot) {
                WritableFontData eotData = new EOTWriter(this.mtx).convert(newFont);
                eotData.copyTo(outputStream);
            } else {
                fontFactory.serializeFont(newFont, outputStream);
            }
            HashMap<String, List<Integer>> hashMap = resultMap;
            return hashMap;
        }
        finally {
            outputStream.close();
        }
    }

    public void setSubsetString(String subsetString) {
        this.subsetString = subsetString;
    }
}

