/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat8
extends CMap {
    private final int numberOfGroups;

    protected CMapFormat8(ReadableFontData data, CMapTable.CMapId cmapId) {
        super(data, CMap.CMapFormat.Format8.value, cmapId);
        this.numberOfGroups = this.data.readULongAsInt(CMapTable.Offset.format8nGroups.offset);
    }

    private int firstChar(int groupIndex) {
        return this.readFontData().readULongAsInt(CMapTable.Offset.format8Groups.offset + groupIndex * CMapTable.Offset.format8Group_structLength.offset + CMapTable.Offset.format8Group_startCharCode.offset);
    }

    private int endChar(int groupIndex) {
        return this.readFontData().readULongAsInt(CMapTable.Offset.format8Groups.offset + groupIndex * CMapTable.Offset.format8Group_structLength.offset + CMapTable.Offset.format8Group_endCharCode.offset);
    }

    @Override
    public int glyphId(int character) {
        return this.readFontData().searchULong(CMapTable.Offset.format8Groups.offset + CMapTable.Offset.format8Group_startCharCode.offset, CMapTable.Offset.format8Group_structLength.offset, CMapTable.Offset.format8Groups.offset + CMapTable.Offset.format8Group_endCharCode.offset, CMapTable.Offset.format8Group_structLength.offset, this.numberOfGroups, character);
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format8Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat8> {
        protected Builder(WritableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format8Length.offset)), CMap.CMapFormat.Format8, cmapId);
        }

        protected Builder(ReadableFontData data, int offset, CMapTable.CMapId cmapId) {
            super(data == null ? null : data.slice(offset, data.readULongAsInt(offset + CMapTable.Offset.format8Length.offset)), CMap.CMapFormat.Format8, cmapId);
        }

        @Override
        protected CMapFormat8 subBuildTable(ReadableFontData data) {
            return new CMapFormat8(data, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int groupIndex = 0;
        private int firstCharInGroup = -1;
        private int endCharInGroup;
        private int nextChar;
        private boolean nextCharSet;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextCharSet) {
                return true;
            }
            while (this.groupIndex < CMapFormat8.this.numberOfGroups) {
                if (this.firstCharInGroup < 0) {
                    this.firstCharInGroup = CMapFormat8.this.firstChar(this.groupIndex);
                    this.endCharInGroup = CMapFormat8.this.endChar(this.groupIndex);
                    this.nextChar = this.firstCharInGroup;
                    this.nextCharSet = true;
                    return true;
                }
                if (this.nextChar < this.endCharInGroup) {
                    ++this.nextChar;
                    this.nextCharSet = true;
                    return true;
                }
                ++this.groupIndex;
                this.firstCharInGroup = -1;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextCharSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextCharSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

