/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.ofd.base.asn1.SES_CertList;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;

public class SES_ESPropertyInfo
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1Integer type;
    private DERUTF8String name;
    private ASN1Integer certListType;
    private SES_CertList certList;
    private Date createDate;
    private Date validStart;
    private Date validEnd;

    public static SES_ESPropertyInfo getInstance(Object o) {
        if (o instanceof SES_ESPropertyInfo) {
            return (SES_ESPropertyInfo)((Object)o);
        }
        if (o != null) {
            return new SES_ESPropertyInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SES_ESPropertyInfo(ASN1Integer type, DERUTF8String name, ASN1Integer certListType, SES_CertList certList, Date createDate, Date validStart, Date validEnd) {
        this.type = type;
        this.name = name;
        this.certListType = certListType;
        this.certList = certList;
        this.createDate = createDate;
        this.validStart = validStart;
        this.validEnd = validEnd;
    }

    public SES_ESPropertyInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.type = (ASN1Integer)e.nextElement();
        this.name = DERUTF8String.getInstance(e.nextElement());
        Object typeOrCert = e.nextElement();
        if (typeOrCert instanceof ASN1Integer) {
            this.certListType = (ASN1Integer)typeOrCert;
        }
        if (null != this.certListType) {
            typeOrCert = (ASN1Primitive)e.nextElement();
        }
        this.certList = SES_CertList.getInstance(typeOrCert, null == this.certListType ? new BigInteger("0") : this.certListType.getValue());
        this.createDate = Time.getInstance(e.nextElement()).getDate();
        this.validStart = Time.getInstance(e.nextElement()).getDate();
        this.validEnd = Time.getInstance(e.nextElement()).getDate();
    }

    public ASN1Integer getType() {
        return this.type;
    }

    public DERUTF8String getName() {
        return this.name;
    }

    public SES_CertList getCertList() {
        return this.certList;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getValidStart() {
        return this.validStart;
    }

    public Date getValidEnd() {
        return this.validEnd;
    }

    public ASN1Integer getCertListType() {
        return this.certListType;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.type);
        v.add((ASN1Encodable)this.name);
        if (null != this.certListType && this.certListType.getValue().intValue() != 0) {
            v.add((ASN1Encodable)this.certListType);
            v.add((ASN1Encodable)this.certList);
            v.add((ASN1Encodable)new ASN1GeneralizedTime(this.createDate));
            v.add((ASN1Encodable)new ASN1GeneralizedTime(this.validStart));
            v.add((ASN1Encodable)new ASN1GeneralizedTime(this.validEnd));
        } else {
            v.add((ASN1Encodable)this.certList);
            v.add((ASN1Encodable)new Time(this.createDate));
            v.add((ASN1Encodable)new Time(this.validStart));
            v.add((ASN1Encodable)new Time(this.validEnd));
        }
        return new DERSequence(v);
    }
}

