/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static Date getUTCTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return new Date(calendar.getTime().getTime());
    }

    public static byte[] getUTCTime(Date signTime) throws IOException {
        byte[] tlvSignTime = new Time(signTime).getEncoded();
        byte[] utcTime = Arrays.copyOfRange(tlvSignTime, 2, tlvSignTime.length);
        return utcTime;
    }

    public static Date addDate(Date date, DateType dateType, int num) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        if (DateType.YEAR.equals((Object)dateType)) {
            c1.add(1, num);
            return c1.getTime();
        }
        if (DateType.MONTH.equals((Object)dateType)) {
            c1.add(2, num);
            return c1.getTime();
        }
        if (DateType.DAY.equals((Object)dateType)) {
            c1.add(5, num);
            return c1.getTime();
        }
        if (DateType.HH.equals((Object)dateType)) {
            c1.add(11, num);
            return c1.getTime();
        }
        if (DateType.MI.equals((Object)dateType)) {
            c1.add(12, num);
            return c1.getTime();
        }
        if (DateType.SS.equals((Object)dateType)) {
            c1.add(13, num);
            return c1.getTime();
        }
        return date;
    }

    public static enum DateType {
        YEAR,
        MONTH,
        DAY,
        HH,
        MI,
        SS,
        YYYY_MM_DD,
        YYYYMMDD;

    }
}

