/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.config;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.ofd.base.common.CFCATSAClient;
import cfca.sadk.ofd.base.util.AbstractSigner;
import cfca.sadk.ofd.base.util.DefaultSigner;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class SignInfoConfig {
    private static Logger businessLog = LoggerFactory.getLogger(SignInfoConfig.class);
    private Session session;
    private Mechanism signAlg;
    private PrivateKey privateKey;
    private X509Cert signCert = null;
    private X509Cert[] certs = null;
    private CFCATSAClient tsaClient = null;
    private boolean isAsyn = false;
    private boolean isSecondHash = false;
    private PrivateKey sealSignerPrivateKey;
    private X509Cert sealSignerCert;
    private AbstractSigner signer = new DefaultSigner();
    private int specification = -1;
    private int signedNum = 0;

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Mechanism getSignAlg() {
        return this.signAlg;
    }

    public void setSignAlg(Mechanism signAlg) {
        this.signAlg = signAlg;
    }

    public void setChain(Certificate[] chain) {
        if (null == chain || chain.length < 1) {
            throw new IllegalArgumentException("certs can not be null.");
        }
        try {
            this.certs = new X509Cert[1];
            this.certs[0] = new X509Cert(chain[0].getEncoded());
            this.signCert = this.certs[0];
        }
        catch (Exception e) {
            businessLog.error("parse chain failed:", (Throwable)e);
        }
    }

    public void setChain(X509Cert[] chain) {
        if (null == chain || chain.length < 1) {
            throw new IllegalArgumentException("certs can not be null.");
        }
        this.certs = chain;
        this.signCert = this.certs[0];
    }

    public void setSignCert(X509Cert signCert) {
        if (null == signCert) {
            throw new IllegalArgumentException("signCert can not be null.");
        }
        this.signCert = signCert;
    }

    public X509Cert getSignCert() {
        return this.signCert;
    }

    public X509Cert[] getCerts() {
        return this.certs;
    }

    public CFCATSAClient getTsaClient() {
        return this.tsaClient;
    }

    public void setTsaClient(CFCATSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public boolean isSecondHash() {
        return this.isSecondHash;
    }

    public void setSecondHash(boolean isSecondHash) {
        this.isSecondHash = isSecondHash;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SignInfoConfig>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump((Mechanism)this.signAlg));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump((PrivateKey)this.privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump((X509Cert)this.signCert));
        buffer.append("\n signCerts: ");
        buffer.append(SADKDebugger.dump((X509Cert[])this.certs));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump((Session)this.session));
        buffer.append("\n isAsyn: ");
        buffer.append(this.isAsyn);
        buffer.append("\n isSecondHash: ");
        buffer.append(this.isSecondHash);
        return buffer.toString();
    }

    public boolean isAsyn() {
        return this.isAsyn;
    }

    public void setAsyn(boolean isAsyn) {
        this.isAsyn = isAsyn;
    }

    public PrivateKey getSealSignerPrivateKey() {
        return this.sealSignerPrivateKey;
    }

    public void setSealSignerPrivateKey(PrivateKey sealSignerPrivateKey) {
        this.sealSignerPrivateKey = sealSignerPrivateKey;
    }

    public X509Cert getSealSignerCert() {
        return this.sealSignerCert;
    }

    public void setSealSignerCert(X509Cert sealSignerCert) {
        this.sealSignerCert = sealSignerCert;
    }

    public AbstractSigner getSigner() {
        return this.signer;
    }

    public void setSigner(AbstractSigner signer) {
        this.signer = signer;
    }

    public int getSpecification() {
        return this.specification;
    }

    public void setSpecification(int specification) {
        this.specification = specification;
        if (specification != 4 && specification != 3) {
            SysEnv.setGBType(false);
        }
    }

    public int getSignedNum() {
        return this.signedNum;
    }

    public void setSignedNum(int signedNum) {
        this.signedNum = signedNum;
    }
}

