/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.util.Base64;
import cfca.seal.maker.util.EndianUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class WebSealExtracter {
    private byte[] p7sourceData;
    private byte[] sourceData;

    public WebSealExtracter(String base64SignedData, byte[] source) throws PKIException {
        this.init(base64SignedData, source);
    }

    private void init(String base64SignedData, byte[] source) throws PKIException {
        byte[] sealedData = Base64.decode((String)base64SignedData);
        byte[] totalLenData = new byte[4];
        System.arraycopy(sealedData, 10, totalLenData, 0, 4);
        int totalLen = EndianUtil.bytesToInt(totalLenData);
        byte[] usbLenData = new byte[4];
        System.arraycopy(sealedData, 14, usbLenData, 0, 4);
        int usbSize = EndianUtil.bytesToInt(usbLenData);
        byte[] usbKeyData = new byte[usbSize + 4];
        System.arraycopy(sealedData, 14, usbKeyData, 0, usbSize + 4);
        byte[] signMessageLen = new byte[4];
        System.arraycopy(sealedData, 18 + usbSize, signMessageLen, 0, 4);
        int signMessageLength = EndianUtil.bytesToInt(signMessageLen);
        byte[] signMessage = new byte[signMessageLength + 4];
        System.arraycopy(sealedData, 18 + usbSize, signMessage, 0, signMessageLength + 4);
        try {
            this.sourceData = this.getSignedSource(usbKeyData, signMessage, source);
        }
        catch (IOException e) {
            throw new PKIException(e.getMessage());
        }
        byte[] p7LenData = new byte[4];
        System.arraycopy(sealedData, 22 + usbSize + signMessageLength, p7LenData, 0, 4);
        int p7Len = totalLen - 4 - usbSize - 4 - signMessageLength - 4;
        int p7Length = EndianUtil.bytesToInt(p7LenData);
        if (p7Len != p7Length) {
            throw new PKIException("the length of p7 error!");
        }
        this.p7sourceData = new byte[p7Len];
        System.arraycopy(sealedData, 26 + usbSize + signMessageLength, this.p7sourceData, 0, p7Len);
    }

    private byte[] getSignedSource(byte[] usbKeyData, byte[] signMessage, byte[] source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int sourceLength = source.length;
        int totalLength = usbKeyData.length + signMessage.length + 4 + sourceLength;
        baos.write(EndianUtil.intToBytes(totalLength));
        baos.write(usbKeyData);
        baos.write(signMessage);
        baos.write(EndianUtil.intToBytes(sourceLength));
        baos.write(source);
        byte[] temp = baos.toByteArray();
        byte[] signSource = new byte[totalLength + 4];
        System.arraycopy(temp, 0, signSource, 0, totalLength + 4);
        return signSource;
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public void setSourceData(byte[] sourceData) {
        this.sourceData = sourceData;
    }

    public byte[] getP7SourceData() {
        return this.p7sourceData;
    }

    public void setP7SourceData(byte[] p7sourceData) {
        this.p7sourceData = p7sourceData;
    }
}

