/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.subsetter;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.Glyph;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.GlyphTable;
import cfca.sadk.com.google.typography.font.sfntly.table.truetype.LocaTable;
import cfca.sadk.com.google.typography.font.tools.subsetter.GlyphRenumberer;
import cfca.sadk.com.google.typography.font.tools.subsetter.Subsetter;
import cfca.sadk.com.google.typography.font.tools.subsetter.TableSubsetterImpl;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GlyphTableSubsetter
extends TableSubsetterImpl {
    private static final boolean DEBUG = false;

    protected GlyphTableSubsetter() {
        super(Tag.glyf, Tag.loca, Tag.maxp);
    }

    @Override
    public boolean subset(Subsetter subsetter, Font font, Font.Builder fontBuilder) throws IOException {
        List<Integer> permutationTable = subsetter.glyphMappingTable();
        if (permutationTable == null) {
            return false;
        }
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        LocaTable locaTable = (LocaTable)font.getTable(Tag.loca);
        if (glyphTable == null || locaTable == null) {
            throw new RuntimeException("Font to subset is not valid.");
        }
        GlyphTable.Builder glyphTableBuilder = (GlyphTable.Builder)fontBuilder.newTableBuilder(Tag.glyf);
        LocaTable.Builder locaTableBuilder = (LocaTable.Builder)fontBuilder.newTableBuilder(Tag.loca);
        if (glyphTableBuilder == null || locaTableBuilder == null) {
            throw new RuntimeException("Builder for subset is not valid.");
        }
        Map<Integer, Integer> inverseMap = subsetter.getInverseMapping();
        List<Glyph.Builder<? extends Glyph>> glyphBuilders = glyphTableBuilder.glyphBuilders();
        for (int oldGlyphId : permutationTable) {
            int oldOffset = locaTable.glyphOffset(oldGlyphId);
            int oldLength = locaTable.glyphLength(oldGlyphId);
            Glyph glyph = glyphTable.glyph(oldOffset, oldLength);
            ReadableFontData data = glyph.readFontData();
            ReadableFontData renumberedData = GlyphRenumberer.renumberGlyph(data, inverseMap);
            Glyph.Builder<? extends Glyph> glyphBuilder = glyphTableBuilder.glyphBuilder(renumberedData);
            glyphBuilders.add(glyphBuilder);
        }
        List<Integer> locaList = glyphTableBuilder.generateLocaList();
        locaTableBuilder.setLocaList(locaList);
        MaximumProfileTable.Builder maxpBuilder = (MaximumProfileTable.Builder)fontBuilder.getTableBuilder(Tag.maxp);
        maxpBuilder.setNumGlyphs(locaTableBuilder.numGlyphs());
        return true;
    }
}

