/*
 * Decompiled with CFR 0.152.
 */
package cfca.integration.uarc.graphics;

import cfca.integration.uarc.fn.CoordTransformer;
import cfca.integration.uarc.fn.EllipseFunction;
import cfca.integration.uarc.graphics.UArcEllipse;
import cfca.integration.uarc.graphics.UArcShape;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;

public class UArcPentagram
extends UArcShape {
    private UArcEllipse uae;
    private int circumradius;
    private double slide;
    private double startAngle;
    private double arcAngle;
    private double theta;
    private float alpha;
    private boolean rounding;
    private int n;
    private Color color;
    private boolean horizontal;
    private EllipseFunction.UArcPoints vuaps;
    private float stroke;

    public UArcPentagram(UArcEllipse uae, int circumradius, boolean rounding, double slide, double startAngle, double arcAngle, int n, boolean horizontal, double theta, float alpha, Color color, float stroke) {
        this.uae = uae;
        this.circumradius = circumradius;
        this.vuaps = this.fromCircumradiusToVertex(circumradius);
        this.rounding = rounding;
        this.slide = slide;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.n = n;
        this.horizontal = horizontal;
        this.theta = theta;
        this.alpha = alpha;
        this.color = color;
        this.stroke = stroke;
    }

    private EllipseFunction.UArcPoints fromCircumradiusToVertex(int circumradius) {
        EllipseFunction.UArcPoints vuaps = new EllipseFunction.UArcPoints(10);
        int cr = circumradius;
        EllipseFunction.UArcPoint uapea0 = new EllipseFunction.UArcPoint();
        uapea0.x0 = (double)cr * Math.cos(Math.toRadians(18.0));
        uapea0.y0 = (double)cr * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapea0);
        EllipseFunction.UArcPoint uapia0 = new EllipseFunction.UArcPoint();
        uapia0.x0 = (double)cr * (1.0 - Math.sin(Math.toRadians(18.0))) * Math.tan(Math.toRadians(18.0));
        uapia0.y0 = (double)cr * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapia0);
        EllipseFunction.UArcPoint uapea1 = new EllipseFunction.UArcPoint();
        uapea1.x0 = 0.0;
        uapea1.y0 = cr;
        vuaps.add(uapea1);
        EllipseFunction.UArcPoint uapia1 = new EllipseFunction.UArcPoint();
        uapia1.x0 = (double)(-cr) * (1.0 - Math.sin(Math.toRadians(18.0))) * Math.tan(Math.toRadians(18.0));
        uapia1.y0 = (double)cr * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapia1);
        EllipseFunction.UArcPoint uapea2 = new EllipseFunction.UArcPoint();
        uapea2.x0 = (double)(-cr) * Math.cos(Math.toRadians(18.0));
        uapea2.y0 = (double)cr * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapea2);
        EllipseFunction.UArcPoint uapia2 = new EllipseFunction.UArcPoint();
        uapia2.x0 = (double)(-cr) * Math.sin(Math.toRadians(18.0)) / Math.cos(Math.toRadians(36.0)) * Math.cos(Math.toRadians(18.0));
        uapia2.y0 = (double)(-cr) * Math.sin(Math.toRadians(18.0)) / Math.cos(Math.toRadians(36.0)) * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapia2);
        EllipseFunction.UArcPoint uapea3 = new EllipseFunction.UArcPoint();
        uapea3.x0 = (double)(-cr) * Math.sin(Math.toRadians(36.0));
        uapea3.y0 = (double)(-cr) * Math.cos(Math.toRadians(36.0));
        vuaps.add(uapea3);
        EllipseFunction.UArcPoint uapia3 = new EllipseFunction.UArcPoint();
        uapia3.x0 = 0.0;
        uapia3.y0 = (double)(-cr) * Math.tan(Math.toRadians(18.0)) / Math.cos(Math.toRadians(36.0));
        vuaps.add(uapia3);
        EllipseFunction.UArcPoint uapea4 = new EllipseFunction.UArcPoint();
        uapea4.x0 = (double)cr * Math.sin(Math.toRadians(36.0));
        uapea4.y0 = (double)(-cr) * Math.cos(Math.toRadians(36.0));
        vuaps.add(uapea4);
        EllipseFunction.UArcPoint uapia4 = new EllipseFunction.UArcPoint();
        uapia4.x0 = (double)cr * Math.sin(Math.toRadians(18.0)) / Math.cos(Math.toRadians(36.0)) * Math.cos(Math.toRadians(18.0));
        uapia4.y0 = (double)(-cr) * Math.sin(Math.toRadians(18.0)) / Math.cos(Math.toRadians(36.0)) * Math.sin(Math.toRadians(18.0));
        vuaps.add(uapia4);
        return vuaps;
    }

    public UArcPentagram(UArcEllipse uae, EllipseFunction.UArcPoints vuaps, boolean rounding, double slide, double startAngle, double arcAngle, int n, boolean horizontal, double theta, float alpha, Color color) {
        this.uae = uae;
        this.circumradius = this.fromVertexToCircumradius(vuaps);
        this.vuaps = vuaps;
        this.rounding = rounding;
        this.slide = slide;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.n = n;
        this.horizontal = horizontal;
        this.theta = theta;
        this.alpha = alpha;
        this.color = color;
    }

    private int fromVertexToCircumradius(EllipseFunction.UArcPoints uaps) {
        EllipseFunction.UArcPoint uapea0 = uaps.get(0);
        double x0 = uapea0.x0;
        double y0 = uapea0.y0;
        double tmpr = Math.sqrt(Math.pow(x0, 2.0) + Math.pow(y0, 2.0));
        int circumradius = (int)tmpr;
        return circumradius;
    }

    public void draw() {
        EllipseFunction.UArcPoints uaps;
        int x = this.uae.getX();
        int y = this.uae.getY();
        int a = this.uae.getWidth() / 2;
        int b = this.uae.getHeight() / 2;
        if (Double.isNaN(this.slide)) {
            uaps = new EllipseFunction.UArcPoints(1);
            EllipseFunction.UArcPoint arcPoint = new EllipseFunction.UArcPoint();
            arcPoint.x0 = 0.0;
            arcPoint.y0 = 0.0;
            arcPoint.normal0 = 0.0;
            uaps.add(arcPoint);
        } else {
            EllipseFunction ellipseFn = new EllipseFunction(a, b);
            double arcLength = ellipseFn.getArcLength(this.startAngle, this.arcAngle);
            double[] angles = ellipseFn.getAngles(arcLength, this.startAngle, this.arcAngle, this.n);
            uaps = ellipseFn.getCenterPoints(angles, this.slide, this.rounding);
        }
        int[][] arrPts = uaps.toArrayXY();
        double[] arrNorm = uaps.toArrayNormal();
        this.draw(arrPts, arrNorm, this.horizontal, this.theta, x, y, a, b, this.alpha);
    }

    private void draw(int[][] arrPts, double[] arrNorm, boolean horizontal, double theta, int x, int y, int a, int b, float alpha) {
        int n = arrPts[0].length;
        CoordTransformer ctf = new CoordTransformer(-a - x, b + y, 0.0);
        BasicStroke oldStroke = (BasicStroke)this.g2d.getStroke();
        this.g2d.setStroke(new BasicStroke(this.stroke));
        Object oldRenderingHint = this.g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = (Color)this.g2d.getPaint();
        this.g2d.setPaint(this.color);
        AlphaComposite newComposite = AlphaComposite.getInstance(3, alpha);
        this.g2d.setComposite(newComposite);
        for (int i = 0; i < n; ++i) {
            int x0 = arrPts[0][i];
            int y0 = arrPts[1][i];
            double normal = arrNorm[i];
            CoordTransformer ctf0 = new CoordTransformer(-x0, -y0, 0.0);
            int[][] vaxy0 = this.vuaps.toArrayXY();
            int[][] vaxy1 = ctf0.translateFromLogicalToLogical(vaxy0);
            int[][] vaxy2 = ctf.translateFromLogicalToDevice(vaxy1);
            int[] xy1 = ctf.translateFromLogicalToDevice(new int[]{x0, y0});
            int x1 = xy1[0];
            int y1 = xy1[1];
            if (horizontal) {
                normal = 0.0;
            } else if (this.rounding) {
                if (x0 == 0 && y0 > 0) {
                    normal = 0.0;
                } else if (x0 == 0 && y0 < 0) {
                    normal = Math.PI;
                } else if (x0 < 0 && y0 == 0) {
                    normal = 1.5707963267948966;
                } else if (x0 > 0 && y0 == 0) {
                    normal = 4.71238898038469;
                } else if (x0 <= 0 || y0 <= 0) {
                    if (x0 < 0 && y0 > 0) {
                        normal -= 1.5707963267948966;
                    } else if (x0 < 0 && y0 < 0) {
                        normal -= 1.5707963267948966;
                    } else if (x0 > 0 && y0 < 0) {
                        normal -= 1.5707963267948966;
                    }
                }
            } else if (!(x0 == 0 && y0 > 0 || x0 == 0 && y0 < 0 || x0 < 0 && y0 == 0 || x0 > 0 && y0 == 0 || x0 > 0 && y0 > 0)) {
                if (x0 < 0 && y0 > 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 < 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                } else if (x0 > 0 && y0 < 0) {
                    normal -= 1.5707963267948966;
                }
            }
            this.g2d.rotate(-(normal += theta), x1, y1);
            this.g2d.fillPolygon(vaxy2[0], vaxy2[1], 10);
            this.g2d.rotate(normal, x1, y1);
        }
        this.g2d.setStroke(oldStroke);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHint);
        this.g2d.setPaint(oldColor);
        this.g2d.setComposite(AlphaComposite.getInstance(3));
    }
}

