/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly;

import cfca.com.google.typography.font.sfntly.FontFactory;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.data.FontInputStream;
import cfca.com.google.typography.font.sfntly.data.FontOutputStream;
import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.math.Fixed1616;
import cfca.com.google.typography.font.sfntly.math.FontMath;
import cfca.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.com.google.typography.font.sfntly.table.Header;
import cfca.com.google.typography.font.sfntly.table.Table;
import cfca.com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import cfca.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import cfca.com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import cfca.com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import cfca.com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import cfca.com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import cfca.com.google.typography.font.sfntly.table.truetype.LocaTable;
import cfca.sadk.ofd.util.SysEnv;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;

public class Font {
    private static final Logger logger = Logger.getLogger(Font.class.getCanonicalName());
    private static final List<Integer> CFF_TABLE_ORDERING;
    private static final List<Integer> TRUE_TYPE_TABLE_ORDERING;
    public static final int SFNTVERSION_1;
    private final int sfntVersion;
    private final byte[] digest;
    private long checksum;
    private Map<Integer, ? extends Table> tables;

    private Font(int sfntVersion, byte[] digest) {
        this.sfntVersion = sfntVersion;
        this.digest = digest;
    }

    public int sfntVersion() {
        return this.sfntVersion;
    }

    public byte[] digest() {
        if (this.digest == null) {
            return null;
        }
        return Arrays.copyOf(this.digest, this.digest.length);
    }

    public long checksum() {
        return this.checksum;
    }

    public int numTables() {
        return this.tables.size();
    }

    public Iterator<? extends Table> iterator() {
        return this.tables.values().iterator();
    }

    public boolean hasTable(int tag) {
        return this.tables.containsKey(tag);
    }

    public <T extends Table> T getTable(int tag) {
        return (T)this.tables.get(tag);
    }

    public Map<Integer, ? extends Table> tableMap() {
        return Collections.unmodifiableMap(this.tables);
    }

    public void clearTableMap() {
        this.tables.clear();
        this.tables = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("digest = ");
        byte[] digest = this.digest();
        if (digest != null) {
            for (int i = 0; i < digest.length; ++i) {
                int d = 0xFF & digest[i];
                if (d < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(d));
            }
        }
        sb.append("\n[");
        sb.append(Fixed1616.toString(this.sfntVersion));
        sb.append(", ");
        sb.append(this.numTables());
        sb.append("]\n");
        Iterator<? extends Table> iter = this.iterator();
        while (iter.hasNext()) {
            FontDataTable table = iter.next();
            sb.append("\t");
            sb.append(table);
            sb.append("\n");
        }
        return sb.toString();
    }

    void serialize(OutputStream os, List<Integer> tableOrdering) throws IOException {
        List<Integer> finalTableOrdering = this.generateTableOrdering(tableOrdering);
        List<Header> tableRecords = this.buildTableHeadersForSerialization(finalTableOrdering);
        FontOutputStream fos = new FontOutputStream(os);
        this.serializeHeader(fos, tableRecords);
        this.serializeTables(fos, tableRecords);
    }

    private List<Header> buildTableHeadersForSerialization(List<Integer> tableOrdering) {
        List<Integer> finalTableOrdering = this.generateTableOrdering(tableOrdering);
        ArrayList<Header> tableHeaders = new ArrayList<Header>(this.numTables());
        int tableOffset = Offset.tableRecordBegin.offset + this.numTables() * Offset.tableRecordSize.offset;
        for (Integer tag : finalTableOrdering) {
            Table table = this.tables.get(tag);
            if (table == null) continue;
            tableHeaders.add(new Header(tag, table.calculatedChecksum(), tableOffset, table.header().length()));
            tableOffset += table.dataLength() + 3 & 0xFFFFFFFC;
        }
        return tableHeaders;
    }

    private void serializeHeader(FontOutputStream fos, List<Header> tableHeaders) throws IOException {
        fos.writeFixed(this.sfntVersion);
        fos.writeUShort(tableHeaders.size());
        int log2OfMaxPowerOf2 = FontMath.log2(tableHeaders.size());
        int searchRange = 2 << log2OfMaxPowerOf2 - 1 + 4;
        fos.writeUShort(searchRange);
        fos.writeUShort(log2OfMaxPowerOf2);
        fos.writeUShort(tableHeaders.size() * 16 - searchRange);
        ArrayList<Header> sortedHeaders = new ArrayList<Header>(tableHeaders);
        Collections.sort(sortedHeaders, Header.COMPARATOR_BY_TAG);
        for (Header record : sortedHeaders) {
            fos.writeULong(record.tag());
            fos.writeULong(record.checksum());
            fos.writeULong(record.offset());
            fos.writeULong(record.length());
        }
    }

    private void serializeTables(FontOutputStream fos, List<Header> tableHeaders) throws IOException {
        for (Header record : tableHeaders) {
            Object table = this.getTable(record.tag());
            if (table == null) {
                throw new IOException("Table out of sync with font header.");
            }
            int tableSize = ((FontDataTable)table).serialize(fos);
            int fillerSize = (tableSize + 3 & 0xFFFFFFFC) - tableSize;
            for (int i = 0; i < fillerSize; ++i) {
                fos.write(0);
            }
        }
    }

    private List<Integer> generateTableOrdering(List<Integer> defaultTableOrdering) {
        ArrayList<Integer> tableOrdering = new ArrayList<Integer>(this.tables.size());
        if (defaultTableOrdering == null) {
            defaultTableOrdering = this.defaultTableOrdering();
        }
        TreeSet<Integer> tablesInFont = new TreeSet<Integer>(this.tables.keySet());
        for (Integer tag : defaultTableOrdering) {
            if (!this.hasTable(tag)) continue;
            tableOrdering.add(tag);
            tablesInFont.remove(tag);
        }
        for (Integer tag : tablesInFont) {
            tableOrdering.add(tag);
        }
        return tableOrdering;
    }

    private List<Integer> defaultTableOrdering() {
        if (this.hasTable(Tag.CFF)) {
            return CFF_TABLE_ORDERING;
        }
        return TRUE_TYPE_TABLE_ORDERING;
    }

    static {
        Integer[] cffArray = new Integer[]{Tag.head, Tag.hhea, Tag.maxp, Tag.OS_2, Tag.name, Tag.cmap, Tag.post, Tag.CFF};
        ArrayList cffList = new ArrayList(cffArray.length);
        Collections.addAll(cffList, cffArray);
        CFF_TABLE_ORDERING = Collections.unmodifiableList(cffList);
        Integer[] ttArray = new Integer[]{Tag.head, Tag.hhea, Tag.maxp, Tag.OS_2, Tag.hmtx, Tag.LTSH, Tag.VDMX, Tag.hdmx, Tag.cmap, Tag.fpgm, Tag.prep, Tag.cvt, Tag.loca, Tag.glyf, Tag.kern, Tag.name, Tag.post, Tag.gasp, Tag.PCLT, Tag.DSIG};
        ArrayList ttList = new ArrayList(ttArray.length);
        Collections.addAll(ttList, ttArray);
        TRUE_TYPE_TABLE_ORDERING = Collections.unmodifiableList(ttList);
        SFNTVERSION_1 = Fixed1616.fixed(1, 0);
    }

    public static final class Builder {
        private Map<Integer, Table.Builder<? extends Table>> tableBuilders;
        private FontFactory factory;
        private int sfntVersion = SFNTVERSION_1;
        private int numTables;
        private int searchRange;
        private int entrySelector;
        private int rangeShift;
        private Map<Header, WritableFontData> dataBlocks;
        private byte[] digest;

        private Builder(FontFactory factory) {
            this.factory = factory;
            this.tableBuilders = new HashMap<Integer, Table.Builder<? extends Table>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFont(InputStream is) throws IOException {
            if (is == null) {
                throw new IOException("No input stream for font.");
            }
            FontInputStream fontIS = null;
            try {
                fontIS = new FontInputStream(is);
                SortedSet<Header> records = this.readHeader(fontIS);
                this.dataBlocks = this.loadTableData(records, fontIS);
                this.tableBuilders = this.buildAllTableBuilders(this.dataBlocks);
            }
            finally {
                if (fontIS != null) {
                    fontIS.close();
                }
            }
        }

        private void loadFont(WritableFontData wfd, int offsetToOffsetTable) throws IOException {
            if (wfd == null) {
                throw new IOException("No data for font.");
            }
            SortedSet<Header> records = this.readHeader(wfd, offsetToOffsetTable);
            this.dataBlocks = this.loadTableData(records, wfd);
            this.tableBuilders = this.buildAllTableBuilders(this.dataBlocks);
        }

        static final Builder getOTFBuilder(FontFactory factory, InputStream is) throws IOException {
            Builder builder = new Builder(factory);
            builder.loadFont(is);
            return builder;
        }

        static final Builder getOTFBuilder(FontFactory factory, WritableFontData wfd, int offsetToOffsetTable) throws IOException {
            Builder builder = new Builder(factory);
            builder.loadFont(wfd, offsetToOffsetTable);
            return builder;
        }

        static final Builder getOTFBuilder(FontFactory factory) {
            return new Builder(factory);
        }

        public FontFactory getFontFactory() {
            return this.factory;
        }

        public boolean readyToBuild() {
            if (this.tableBuilders == null && this.dataBlocks != null && this.dataBlocks.size() > 0) {
                return true;
            }
            for (Table.Builder<? extends Table> tableBuilder : this.tableBuilders.values()) {
                if (tableBuilder.readyToBuild()) continue;
                return false;
            }
            return true;
        }

        public Font build() {
            Map<Integer, Table> tables = null;
            Font font = new Font(this.sfntVersion, this.digest);
            if (this.tableBuilders.size() > 0) {
                tables = Builder.buildTablesFromBuilders(font, this.tableBuilders);
            }
            font.tables = tables;
            this.tableBuilders = null;
            this.dataBlocks = null;
            return font;
        }

        public void setDigest(byte[] digest) {
            this.digest = digest;
        }

        public void clearTableBuilders() {
            this.tableBuilders.clear();
        }

        public boolean hasTableBuilder(int tag) {
            return this.tableBuilders.containsKey(tag);
        }

        public Table.Builder<? extends Table> getTableBuilder(int tag) {
            Table.Builder<? extends Table> builder = this.tableBuilders.get(tag);
            return builder;
        }

        public Table.Builder<? extends Table> newTableBuilder(int tag) {
            Header header = new Header(tag);
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, null);
            this.tableBuilders.put(header.tag(), builder);
            return builder;
        }

        public Table.Builder<? extends Table> newTableBuilder(int tag, ReadableFontData srcData) {
            WritableFontData data = WritableFontData.createWritableFontData(srcData.length());
            srcData.copyTo(data);
            Header header = new Header(tag, data.length());
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, data);
            this.tableBuilders.put(tag, builder);
            return builder;
        }

        public Map<Integer, Table.Builder<? extends Table>> tableBuilderMap() {
            return Collections.unmodifiableMap(this.tableBuilders);
        }

        public Table.Builder<? extends Table> removeTableBuilder(int tag) {
            return this.tableBuilders.remove(tag);
        }

        public int tableBuilderCount() {
            return this.tableBuilders.size();
        }

        private int sfntWrapperSize() {
            return Offset.sfntHeaderSize.offset + Offset.tableRecordSize.offset * this.tableBuilders.size();
        }

        private Map<Integer, Table.Builder<? extends Table>> buildAllTableBuilders(Map<Header, WritableFontData> tableData) {
            HashMap<Integer, Table.Builder<? extends Table>> builderMap = new HashMap<Integer, Table.Builder<? extends Table>>();
            Set<Header> records = tableData.keySet();
            for (Header record : records) {
                Table.Builder<? extends Table> builder = this.getTableBuilder(record, tableData.get(record));
                builderMap.put(record.tag(), builder);
            }
            Builder.interRelateBuilders(builderMap);
            return builderMap;
        }

        private Table.Builder<? extends Table> getTableBuilder(Header header, WritableFontData data) {
            Table.Builder<Table> builder = Table.Builder.getBuilder(header, data);
            return builder;
        }

        private static Map<Integer, Table> buildTablesFromBuilders(Font font, Map<Integer, Table.Builder<? extends Table>> builderMap) {
            TreeMap<Integer, Table> tableMap = new TreeMap<Integer, Table>();
            Builder.interRelateBuilders(builderMap);
            long fontChecksum = 0L;
            boolean tablesChanged = false;
            FontDataTable.Builder headerTableBuilder = null;
            for (Table.Builder<? extends Table> builder : builderMap.values()) {
                Table table = null;
                if (Tag.isHeaderTable(builder.header().tag())) {
                    headerTableBuilder = (FontHeaderTable.Builder)builder;
                    continue;
                }
                if (builder.readyToBuild()) {
                    tablesChanged |= builder.changed();
                    table = (Table)builder.build();
                }
                if (table == null) {
                    throw new RuntimeException("Unable to build table - " + builder);
                }
                long tableChecksum = table.calculatedChecksum();
                fontChecksum += tableChecksum;
                tableMap.put(table.header().tag(), table);
            }
            FontDataTable headerTable = null;
            if (headerTableBuilder != null) {
                if (tablesChanged) {
                    ((FontHeaderTable.Builder)headerTableBuilder).setFontChecksum(fontChecksum);
                }
                if (headerTableBuilder.readyToBuild()) {
                    tablesChanged |= headerTableBuilder.changed();
                    headerTable = ((TableBasedTableBuilder)headerTableBuilder).build();
                }
                if (headerTable == null) {
                    throw new RuntimeException("Unable to build table - " + headerTableBuilder);
                }
                fontChecksum += ((Table)headerTable).calculatedChecksum();
                tableMap.put(((Table)headerTable).header().tag(), (Table)headerTable);
            }
            font.checksum = fontChecksum & 0xFFFFFFFFL;
            return tableMap;
        }

        private static void interRelateBuilders(Map<Integer, Table.Builder<? extends Table>> builderMap) {
            FontHeaderTable.Builder headerTableBuilder = (FontHeaderTable.Builder)builderMap.get(Tag.head);
            HorizontalHeaderTable.Builder horizontalHeaderBuilder = (HorizontalHeaderTable.Builder)builderMap.get(Tag.hhea);
            MaximumProfileTable.Builder maxProfileBuilder = (MaximumProfileTable.Builder)builderMap.get(Tag.maxp);
            LocaTable.Builder locaTableBuilder = (LocaTable.Builder)builderMap.get(Tag.loca);
            HorizontalMetricsTable.Builder horizontalMetricsBuilder = (HorizontalMetricsTable.Builder)builderMap.get(Tag.hmtx);
            HorizontalDeviceMetricsTable.Builder hdmxTableBuilder = (HorizontalDeviceMetricsTable.Builder)builderMap.get(Tag.hdmx);
            if (horizontalMetricsBuilder != null) {
                if (maxProfileBuilder != null) {
                    horizontalMetricsBuilder.setNumGlyphs(maxProfileBuilder.numGlyphs());
                }
                if (horizontalHeaderBuilder != null) {
                    horizontalMetricsBuilder.setNumberOfHMetrics(horizontalHeaderBuilder.numberOfHMetrics());
                }
            }
            if (locaTableBuilder != null) {
                if (maxProfileBuilder != null) {
                    locaTableBuilder.setNumGlyphs(maxProfileBuilder.numGlyphs());
                }
                if (headerTableBuilder != null) {
                    locaTableBuilder.setFormatVersion(headerTableBuilder.indexToLocFormat());
                }
            }
            if (hdmxTableBuilder != null && maxProfileBuilder != null) {
                hdmxTableBuilder.setNumGlyphs(maxProfileBuilder.numGlyphs());
            }
        }

        private SortedSet<Header> readHeader(FontInputStream is) throws IOException {
            TreeSet<Header> records = new TreeSet<Header>(Header.COMPARATOR_BY_OFFSET);
            this.sfntVersion = is.readFixed();
            this.numTables = is.readUShort();
            this.searchRange = is.readUShort();
            this.entrySelector = is.readUShort();
            this.rangeShift = is.readUShort();
            for (int tableNumber = 0; tableNumber < this.numTables; ++tableNumber) {
                Header table = new Header(is.readULongAsInt(), is.readULong(), is.readULongAsInt(), is.readULongAsInt());
                records.add(table);
            }
            return records;
        }

        private Map<Header, WritableFontData> loadTableData(SortedSet<Header> headers, FontInputStream is) throws IOException {
            HashMap<Header, WritableFontData> tableData = new HashMap<Header, WritableFontData>(headers.size());
            logger.fine("########  Reading Table Data");
            for (Header tableHeader : headers) {
                is.skip((long)tableHeader.offset() - is.position());
                logger.finer("\t" + tableHeader);
                logger.finest("\t\tStream Position = " + Integer.toHexString((int)is.position()));
                int tableLength = tableHeader.length();
                if (tableLength > SysEnv.getMaxFontFileLength()) {
                    throw new IllegalArgumentException("tableHeader.length() is " + tableLength);
                }
                FontInputStream tableIS = new FontInputStream(is, tableLength);
                WritableFontData data = WritableFontData.createWritableFontData(tableHeader.length());
                data.copyFrom(tableIS, tableHeader.length());
                tableData.put(tableHeader, data);
            }
            return tableData;
        }

        private SortedSet<Header> readHeader(ReadableFontData fd, int offset) {
            TreeSet<Header> records = new TreeSet<Header>(Header.COMPARATOR_BY_OFFSET);
            this.sfntVersion = fd.readFixed(offset + Offset.sfntVersion.offset);
            this.numTables = fd.readUShort(offset + Offset.numTables.offset);
            this.searchRange = fd.readUShort(offset + Offset.searchRange.offset);
            this.entrySelector = fd.readUShort(offset + Offset.entrySelector.offset);
            this.rangeShift = fd.readUShort(offset + Offset.rangeShift.offset);
            int tableOffset = offset + Offset.tableRecordBegin.offset;
            int tableNumber = 0;
            while (tableNumber < this.numTables) {
                Header table = new Header(fd.readULongAsInt(tableOffset + Offset.tableTag.offset), fd.readULong(tableOffset + Offset.tableCheckSum.offset), fd.readULongAsInt(tableOffset + Offset.tableOffset.offset), fd.readULongAsInt(tableOffset + Offset.tableLength.offset));
                records.add(table);
                ++tableNumber;
                tableOffset += Offset.tableRecordSize.offset;
            }
            return records;
        }

        private Map<Header, WritableFontData> loadTableData(SortedSet<Header> headers, WritableFontData fd) {
            HashMap<Header, WritableFontData> tableData = new HashMap<Header, WritableFontData>(headers.size());
            logger.fine("########  Reading Table Data");
            for (Header tableHeader : headers) {
                int tableLength = tableHeader.length();
                if (tableLength > SysEnv.getMaxFontFileLength()) {
                    throw new IllegalArgumentException("tableHeader.length() is " + tableLength);
                }
                WritableFontData data = fd.slice(tableHeader.offset(), tableHeader.length());
                tableData.put(tableHeader, data);
            }
            return tableData;
        }
    }

    public static enum MacintoshEncodingId {
        Unknown(-1),
        Roman(0),
        Japanese(1),
        ChineseTraditional(2),
        Korean(3),
        Arabic(4),
        Hebrew(5),
        Greek(6),
        Russian(7),
        RSymbol(8),
        Devanagari(9),
        Gurmukhi(10),
        Gujarati(11),
        Oriya(12),
        Bengali(13),
        Tamil(14),
        Telugu(15),
        Kannada(16),
        Malayalam(17),
        Sinhalese(18),
        Burmese(19),
        Khmer(20),
        Thai(21),
        Laotian(22),
        Georgian(23),
        Armenian(24),
        ChineseSimplified(25),
        Tibetan(26),
        Mongolian(27),
        Geez(28),
        Slavic(29),
        Vietnamese(30),
        Sindhi(31),
        Uninterpreted(32);

        private final int value;

        private MacintoshEncodingId(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static MacintoshEncodingId valueOf(int value) {
            for (MacintoshEncodingId encoding : MacintoshEncodingId.values()) {
                if (!encoding.equals(value)) continue;
                return encoding;
            }
            return Unknown;
        }
    }

    public static enum WindowsEncodingId {
        Unknown(-1),
        Symbol(0),
        UnicodeUCS2(1),
        ShiftJIS(2),
        PRC(3),
        Big5(4),
        Wansung(5),
        Johab(6),
        UnicodeUCS4(10);

        private final int value;

        private WindowsEncodingId(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static WindowsEncodingId valueOf(int value) {
            for (WindowsEncodingId encoding : WindowsEncodingId.values()) {
                if (!encoding.equals(value)) continue;
                return encoding;
            }
            return Unknown;
        }
    }

    public static enum UnicodeEncodingId {
        Unknown(-1),
        Unicode1_0(0),
        Unicode1_1(1),
        ISO10646(2),
        Unicode2_0_BMP(3),
        Unicode2_0(4),
        UnicodeVariationSequences(5);

        private final int value;

        private UnicodeEncodingId(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static UnicodeEncodingId valueOf(int value) {
            for (UnicodeEncodingId encoding : UnicodeEncodingId.values()) {
                if (!encoding.equals(value)) continue;
                return encoding;
            }
            return Unknown;
        }
    }

    public static enum PlatformId {
        Unknown(-1),
        Unicode(0),
        Macintosh(1),
        ISO(2),
        Windows(3),
        Custom(4);

        private final int value;

        private PlatformId(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(int value) {
            return value == this.value;
        }

        public static PlatformId valueOf(int value) {
            for (PlatformId platform : PlatformId.values()) {
                if (!platform.equals(value)) continue;
                return platform;
            }
            return Unknown;
        }
    }

    private static enum Offset {
        sfntVersion(0),
        numTables(4),
        searchRange(6),
        entrySelector(8),
        rangeShift(10),
        tableRecordBegin(12),
        sfntHeaderSize(12),
        tableTag(0),
        tableCheckSum(4),
        tableOffset(8),
        tableLength(12),
        tableRecordSize(16);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

