/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.ofd.base.common.CertVerifyUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.x509.certificate.X509Cert;
import java.util.Arrays;
import java.util.Date;

public class ParamCheckUtil {
    private static Logger businessLog = LoggerFactory.getLogger(ParamCheckUtil.class);

    public static void checkCertValidity(Date signDate, X509Cert x509Cert, int verifyLevel) throws SealException {
        if (null != x509Cert) {
            boolean isRevoke;
            Date notBefore = x509Cert.getNotBefore();
            Date notAfter = x509Cert.getNotAfter();
            if (signDate.before(notBefore)) {
                throw new SealException("x509Cert is not valid, signDate=" + signDate + " DN=" + x509Cert.getSubject());
            }
            if (signDate.after(notAfter)) {
                throw new SealException("x509Cert is expired, signDate=" + signDate + " DN=" + x509Cert.getSubject());
            }
            if (verifyLevel == -1 || (verifyLevel & 8) == 8) {
                try {
                    boolean[] keyUsage = CertVerifyUtil.getCertKeyUsage(x509Cert);
                    if (null == keyUsage || !keyUsage[0]) {
                        throw new SealException("signCert's keyUsage not contain digitalSignature! " + Arrays.toString(keyUsage));
                    }
                }
                catch (SealException e1) {
                    businessLog.error("checkCertKeyUsage failed:", (Throwable)e1);
                    throw e1;
                }
                catch (Exception e2) {
                    businessLog.error("checkCertKeyUsage failed:", (Throwable)e2);
                    throw new SealException("checkCertKeyUsage failed:", e2);
                }
            }
            if ((verifyLevel == -1 || (verifyLevel & 4) == 4) && SysEnv.isCrlLoaded() && (isRevoke = CertVerifyUtil.verifyByCRL(x509Cert, signDate))) {
                throw new SealException("x509Cert is revoked, signDate=" + signDate + " DN=" + x509Cert.getSubject());
            }
            if ((verifyLevel == -1 || (verifyLevel & 2) == 2) && SysEnv.isTrustCertLoaded()) {
                try {
                    businessLog.info("verifyCertSign dn is: " + x509Cert.getSubject());
                    boolean isTrustCert = CertVerifyUtil.verifyCertSign(x509Cert);
                    if (!isTrustCert) {
                        throw new SealException("x509Cert is not trusted, signDate=" + signDate + " DN=" + x509Cert.getSubject());
                    }
                }
                catch (PKIException e) {
                    businessLog.error("verifyCertSign failed,dn is: " + x509Cert.getSubject(), (Throwable)e);
                    throw new SealException("verifyCertSign failed:", e);
                }
            }
        } else {
            throw new SealException("x509Cert is null");
        }
    }

    public static void checkCertValidity(X509Cert x509Cert, int verifyLevel) throws SealException {
        ParamCheckUtil.checkCertValidity(new Date(), x509Cert, verifyLevel);
    }

    public static void checkDateValidity(Date startDate, Date endDate, Date signDate, String desc) throws SealException {
        if (startDate.after(signDate)) {
            throw new SealException(desc + " is not valid,startDate=" + startDate);
        }
        if (signDate.after(endDate)) {
            throw new SealException(desc + " is expired,endDate=" + endDate);
        }
    }

    public static void checkAlpha(int alpha) throws SealException {
        if (alpha < 0 || alpha > 255) {
            throw new SealException("The value range of alpha is 0 to 255!");
        }
    }

    public static void checkPageNum(int pageNum) throws SealException {
        if (pageNum <= 0) {
            throw new SealException("pageNum = " + pageNum + " is wrong!");
        }
    }

    public static void checkPageNum(int pageNum, int totalPages) throws SealException {
        if (pageNum <= 0) {
            throw new SealException("pageNum = " + pageNum + " is wrong!");
        }
        if (pageNum > totalPages) {
            throw new SealException("pageNum = " + pageNum + " is larger than totalPages " + totalPages);
        }
    }
}

