/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.conversion.eot;

import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.tools.conversion.eot.MtxHeadBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MtxFontBuilder {
    private static final int OPENTYPE_VERSION_1_0 = 65536;
    private static final int FONT_HEADER_BASE_SIZE = 12;
    private static final int FONT_HEADER_PER_TABLE_SIZE = 16;
    private static final int TABLE_ALIGN = 4;
    private Map<Integer, ReadableFontData> tables = new HashMap<Integer, ReadableFontData>();
    private MtxHeadBuilder headBuilder = new MtxHeadBuilder();

    public MtxHeadBuilder getHeadBuilder() {
        return this.headBuilder;
    }

    public void addTable(int tag, ReadableFontData data) {
        this.tables.put(tag, data);
    }

    public void addTableBytes(int tag, byte[] data) {
        this.addTable(tag, ReadableFontData.createReadableFontData(data));
    }

    private static void putUshort(byte[] buf, int offset, int val) {
        buf[offset] = (byte)(val >> 8);
        buf[offset + 1] = (byte)val;
    }

    private static void putUlong(byte[] buf, int offset, int val) {
        buf[offset] = (byte)(val >> 24);
        buf[offset + 1] = (byte)(val >> 16);
        buf[offset + 2] = (byte)(val >> 8);
        buf[offset + 3] = (byte)val;
    }

    public byte[] build() {
        this.addTable(Tag.head, this.headBuilder.build());
        TreeSet<Integer> tags = new TreeSet<Integer>(this.tables.keySet());
        int nTables = this.tables.size();
        int size = 12 + 16 * nTables;
        for (Map.Entry<Integer, ReadableFontData> entry : this.tables.entrySet()) {
            ReadableFontData data = entry.getValue();
            if (data == null) continue;
            size += entry.getValue().length() + 4 - 1 & 0xFFFFFFFC;
        }
        byte[] buf = new byte[size];
        MtxFontBuilder.putUlong(buf, 0, 65536);
        MtxFontBuilder.putUshort(buf, 4, nTables);
        boolean entrySelector = false;
        int searchRange = MtxFontBuilder.searchRange(nTables);
        MtxFontBuilder.putUshort(buf, 6, searchRange * 16);
        MtxFontBuilder.putUshort(buf, 8, MtxFontBuilder.log2(searchRange));
        MtxFontBuilder.putUshort(buf, 10, (nTables - searchRange) * 16);
        int headerOffset = 12;
        int offset = 12 + 16 * nTables;
        for (Integer tag : tags) {
            ReadableFontData data = this.tables.get(tag);
            MtxFontBuilder.putUlong(buf, headerOffset, tag);
            int checksum = 0;
            MtxFontBuilder.putUlong(buf, headerOffset + 4, checksum);
            if (data == null) {
                MtxFontBuilder.putUlong(buf, headerOffset + 8, 0);
                MtxFontBuilder.putUlong(buf, headerOffset + 12, 0);
            } else {
                MtxFontBuilder.putUlong(buf, headerOffset + 8, offset);
                int length = data.length();
                MtxFontBuilder.putUlong(buf, headerOffset + 12, length);
                data.readBytes(0, buf, offset, length);
                offset += length + 4 - 1 & 0xFFFFFFFC;
            }
            headerOffset += 16;
        }
        return buf;
    }

    static int searchRange(int x) {
        return Integer.highestOneBit(x);
    }

    static int log2(int x) {
        return 31 - Integer.numberOfLeadingZeros(x);
    }
}

