/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.cmp;

import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIBody;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIHeader;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIMessage;
import cfca.sadk.org.bouncycastle.cert.CertIOException;
import java.io.IOException;

public class GeneralPKIMessage {
    private final PKIMessage pkiMessage;

    private static PKIMessage parseBytes(byte[] encoding) throws IOException {
        try {
            return PKIMessage.getInstance(ASN1Primitive.fromByteArray(encoding));
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public GeneralPKIMessage(byte[] encoding) throws IOException {
        this(GeneralPKIMessage.parseBytes(encoding));
    }

    public GeneralPKIMessage(PKIMessage pkiMessage) {
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public boolean hasProtection() {
        return this.pkiMessage.getHeader().getProtectionAlg() != null;
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }
}

