/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.signature.AbstractPKCS7Package;
import cfca.sadk.signature.PKCS7ECCPackageUtil;
import cfca.sadk.signature.PKCS7RSAPackageUtil;
import cfca.sadk.signature.PKCS7SM2PackageUtil;
import cfca.sadk.x509.certificate.X509Cert;

public class PKCS7PackageFacade {
    private static final AbstractPKCS7Package sm2Package = new PKCS7SM2PackageUtil();
    private static final AbstractPKCS7Package rsaPackage = new PKCS7RSAPackageUtil();
    private static final AbstractPKCS7Package eccPackage = new PKCS7ECCPackageUtil();

    public static final byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        if (receiverCerts == null || receiverCerts.length < 1 || receiverCerts[0] == null) {
            throw new PKIException("required receiverCerts!");
        }
        byte[] signResult = null;
        signResult = receiverCerts[0].isSM2Cert() ? sm2Package.packageSignedData(ifAttach, contentType, sourceData, encryptData, null, receiverCerts) : (receiverCerts[0].isECCCert() ? eccPackage.packageSignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, receiverCerts) : rsaPackage.packageSignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, receiverCerts));
        return signResult;
    }

    public static final void packageSignedFile(String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] receiverCerts) throws PKIException {
        if (receiverCerts == null || receiverCerts.length < 1 || receiverCerts[0] == null) {
            throw new PKIException("required receiverCerts!");
        }
        if (receiverCerts[0].isSM2Cert()) {
            sm2Package.packageSignedFile(sourceFilePath, signFile, signture, null, receiverCerts);
        } else if (receiverCerts[0].isECCCert()) {
            eccPackage.packageSignedFile(sourceFilePath, signFile, signture, mechanism, receiverCerts);
        } else {
            rsaPackage.packageSignedFile(sourceFilePath, signFile, signture, mechanism, receiverCerts);
        }
    }
}

