/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.signature.AbstractPKCS7Package;
import cfca.sadk.system.Mechanisms;

final class PKCS7RSAPackageUtil
extends AbstractPKCS7Package {
    PKCS7RSAPackageUtil() {
    }

    public ASN1Object getSignerInfo(byte[] signature, IssuerAndSerialNumber issuerAndSn, Mechanism mechanism) throws PKIException {
        AlgorithmIdentifier digestAlgIdentifier = this.getDigestAlgIdentifier(mechanism);
        DEROctetString encryptedData = new DEROctetString(signature);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
        SignerInfo signerInfo = new SignerInfo(signInfoVersion, issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
        return signerInfo;
    }

    public AlgorithmIdentifier getDigestAlgIdentifier(Mechanism mechanism) throws PKIException {
        AlgorithmIdentifier digestAlgIdentifier = Mechanisms.getDigestAlgIdentifier(mechanism);
        if (digestAlgIdentifier == null) {
            throw new PKIException("Invalid DigestAlgIdentifier: " + mechanism);
        }
        return digestAlgIdentifier;
    }

    public ASN1ObjectIdentifier getContentIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.data;
    }

    public ASN1ObjectIdentifier getSignDataIdentifier() throws PKIException {
        return PKCSObjectIdentifiers.signedData;
    }
}

