/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;

public final class SM2OutputFormat {
    static boolean standard = true;

    private SM2OutputFormat() {
    }

    public static byte[] sm2FormatEncryptedRAWBytes(byte[] encryptedBytes) {
        if (ASN1SM2Cipher.isASN1EncryptType(encryptedBytes)) {
            encryptedBytes = ASN1SM2Cipher.getInstance(encryptedBytes).getEncryptedBytes(4);
        }
        return encryptedBytes;
    }

    public static final byte[] sm2FormatSigned64Bytes(byte[] signedBytes) {
        if (ASN1SM2Signature.isASN1SignType(signedBytes)) {
            signedBytes = ASN1SM2Signature.getInstance(signedBytes).getRSRaw64Bytes();
        }
        return signedBytes;
    }

    public static final byte[] sm2FormatSignedASN1Bytes(byte[] signedBytes) {
        if (signedBytes != null && signedBytes.length == 64) {
            try {
                signedBytes = new ASN1SM2Signature(signedBytes).getEncoded("DER");
            }
            catch (Exception e) {
                throw new SecurityException("sm2FormatSignedASN1Bytes failure");
            }
        }
        return signedBytes;
    }

    public static final byte[] sm2FormatSignedBytes(byte[] signedBytes) {
        signedBytes = standard ? SM2OutputFormat.sm2FormatSignedASN1Bytes(signedBytes) : SM2OutputFormat.sm2FormatSigned64Bytes(signedBytes);
        return signedBytes;
    }
}

