/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import cfca.sadk.org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import cfca.sadk.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.sadk.org.bouncycastle.operator.ContentVerifier;
import cfca.sadk.org.bouncycastle.operator.ContentVerifierProvider;
import cfca.sadk.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import cfca.sadk.timestamp.client.TSACertHolder;
import cfca.sadk.timestamp.client.TSAContentVerifier;
import cfca.sadk.timestamp.client.TSADigestCalculator;
import java.util.HashSet;
import java.util.Set;

final class TSASignerInformationVerifier {
    static final CMSSignatureAlgorithmNameGenerator SIGNATURE_ALGORITHM_NAME_GENERATOR = new DefaultCMSSignatureAlgorithmNameGenerator();
    static final SignatureAlgorithmIdentifierFinder SIGNATURE_ALGORITHM_IDENTIFIER_FINDER = new DefaultSignatureAlgorithmIdentifierFinder();
    private static final Set<Object> SM2_SIGN_ALG = new HashSet<Object>();

    TSASignerInformationVerifier() {
    }

    static final SignerInformationVerifier buildSignerInformationVerifier(final TSACertHolder holder, final Session session) {
        final ASN1ObjectIdentifier oidSM3WithSM2 = GMObjectIdentifiers.sm3WithSM2Encryption;
        String nameSM3WithSM2 = "SM3WithSM2";
        CMSSignatureAlgorithmNameGenerator sigNameGenerator = new CMSSignatureAlgorithmNameGenerator(){

            public String getSignatureName(AlgorithmIdentifier digestAlg, AlgorithmIdentifier encryptionAlg) {
                String signName = SM2_SIGN_ALG.contains(encryptionAlg.getAlgorithm()) ? "SM3WithSM2" : SIGNATURE_ALGORITHM_NAME_GENERATOR.getSignatureName(digestAlg, encryptionAlg);
                return signName;
            }
        };
        SignatureAlgorithmIdentifierFinder sigAlgorithmFinder = new SignatureAlgorithmIdentifierFinder(){

            public AlgorithmIdentifier find(String sigAlgName) {
                AlgorithmIdentifier aid = SM2_SIGN_ALG.contains(sigAlgName) ? new AlgorithmIdentifier(oidSM3WithSM2, (ASN1Encodable)DERNull.INSTANCE) : SIGNATURE_ALGORITHM_IDENTIFIER_FINDER.find(sigAlgName);
                return aid;
            }
        };
        ContentVerifierProvider verifierProvider = new ContentVerifierProvider(){

            public boolean hasAssociatedCertificate() {
                return holder != null;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return holder;
            }

            public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
                return new TSAContentVerifier(verifierAlgorithmIdentifier, holder, session);
            }
        };
        DigestCalculatorProvider digestProvider = new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return new TSADigestCalculator(digestAlgorithmIdentifier);
            }
        };
        return new SignerInformationVerifier(sigNameGenerator, sigAlgorithmFinder, verifierProvider, digestProvider);
    }

    static {
        SM2_SIGN_ALG.add(GMObjectIdentifiers.sm2Sign);
        SM2_SIGN_ALG.add(GMObjectIdentifiers.sm3WithSM2Encryption);
        SM2_SIGN_ALG.add(GMObjectIdentifiers.sm3WithSM2Encryption_old);
    }
}

