/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf.security;

import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.security.CertificateVerifier;
import cfca.com.itextpdf.text.pdf.security.VerificationOK;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootStoreVerifier
extends CertificateVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RootStoreVerifier.class);
    protected KeyStore rootStore = null;

    public RootStoreVerifier(CertificateVerifier verifier) {
        super(verifier);
    }

    public void setRootStore(KeyStore keyStore) {
        this.rootStore = keyStore;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        LOGGER.info("Root store verification: " + signCert.getSubjectDN().getName());
        if (this.rootStore == null) {
            return super.verify(signCert, issuerCert, signDate);
        }
        try {
            ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
            Enumeration<String> aliases = this.rootStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    if (!this.rootStore.isCertificateEntry(alias)) continue;
                    X509Certificate anchor = (X509Certificate)this.rootStore.getCertificate(alias);
                    signCert.verify(anchor.getPublicKey());
                    LOGGER.info("Certificate verified against root store");
                    result.add(new VerificationOK(signCert, this.getClass(), "Certificate verified against root store."));
                    result.addAll(super.verify(signCert, issuerCert, signDate));
                    return result;
                }
                catch (GeneralSecurityException e) {
                }
            }
            result.addAll(super.verify(signCert, issuerCert, signDate));
            return result;
        }
        catch (GeneralSecurityException e) {
            return super.verify(signCert, issuerCert, signDate);
        }
    }
}

