/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.css;

import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.css.CssUtils;

public class HeightCalculator {
    private final CssUtils utils = CssUtils.getInstance();

    public Float getHeight(Tag tag, float pageHeight) {
        Float height = null;
        String heightValue = tag.getCSS().get("height");
        if (heightValue == null) {
            heightValue = tag.getAttributes().get("height");
        }
        if (heightValue != null) {
            if (this.utils.isNumericValue(heightValue) || this.utils.isMetricValue(heightValue)) {
                height = Float.valueOf(this.utils.parsePxInCmMmPcToPt(heightValue));
            } else if (this.utils.isRelativeValue(heightValue)) {
                Tag ancestor = tag;
                Float firstAncestorsWidth = null;
                while (firstAncestorsWidth == null && ancestor.getParent() != null) {
                    ancestor = ancestor.getParent();
                    firstAncestorsWidth = this.getHeight(ancestor, pageHeight);
                }
                height = firstAncestorsWidth == null ? Float.valueOf(this.utils.parseRelativeValue(heightValue, pageHeight)) : Float.valueOf(this.utils.parseRelativeValue(heightValue, firstAncestorsWidth.floatValue()));
            }
        }
        return height;
    }
}

