/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.font;

import cfca.sadk.com.itextpdf.io.font.otf.Glyph;
import cfca.sadk.com.itextpdf.io.util.TextUtil;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.layout.font.FontInfo;
import cfca.sadk.com.itextpdf.layout.font.FontProvider;
import cfca.sadk.com.itextpdf.layout.font.FontSelector;
import cfca.sadk.com.itextpdf.layout.font.FontSelectorStrategy;
import cfca.sadk.com.itextpdf.layout.font.FontSet;
import cfca.sadk.com.itextpdf.layout.jdk7.MyCharacter;
import java.util.ArrayList;
import java.util.List;

public class ComplexFontSelectorStrategy
extends FontSelectorStrategy {
    private PdfFont font = null;
    private FontSelector selector;

    public ComplexFontSelectorStrategy(String text, FontSelector selector, FontProvider provider, FontSet tempFonts) {
        super(text, provider, tempFonts);
        this.selector = selector;
    }

    public ComplexFontSelectorStrategy(String text, FontSelector selector, FontProvider provider) {
        super(text, provider, null);
        this.selector = selector;
    }

    @Override
    public PdfFont getCurrentFont() {
        return this.font;
    }

    @Override
    public List<Glyph> nextGlyphs() {
        this.font = null;
        int nextUnignorable = this.nextSignificantIndex();
        if (nextUnignorable < this.text.length()) {
            for (FontInfo f : this.selector.getFonts()) {
                PdfFont currentFont = this.getPdfFont(f);
                if (!currentFont.containsGlyph(this.text, nextUnignorable)) continue;
                this.font = currentFont;
                break;
            }
        }
        ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
        boolean anyGlyphsAppended = false;
        if (this.font != null) {
            int codePoint;
            MyCharacter.UnicodeScript currScript;
            MyCharacter.UnicodeScript unicodeScript = this.nextSignificantUnicodeScript(nextUnignorable);
            int to = nextUnignorable;
            for (int i = nextUnignorable; !(i >= this.text.length() || ComplexFontSelectorStrategy.isSignificantUnicodeScript(currScript = MyCharacter.UnicodeScript.of(codePoint = ComplexFontSelectorStrategy.isSurrogatePair(this.text, i) ? TextUtil.convertToUtf32(this.text, i) : (int)this.text.charAt(i))) && currScript != unicodeScript); ++i) {
                if (codePoint > 65535) {
                    // empty if block
                }
                to = ++i;
            }
            int numOfAppendedGlyphs = this.font.appendGlyphs(this.text, this.index, to, glyphs);
            boolean bl = anyGlyphsAppended = numOfAppendedGlyphs > 0;
            assert (anyGlyphsAppended);
            this.index += numOfAppendedGlyphs;
        }
        if (!anyGlyphsAppended) {
            this.font = this.getPdfFont(this.selector.bestMatch());
            if (this.index != nextUnignorable) {
                this.index += this.font.appendGlyphs(this.text, this.index, nextUnignorable - 1, glyphs);
            }
            while (this.index <= nextUnignorable && this.index < this.text.length()) {
                this.index += this.font.appendAnyGlyph(this.text, this.index, glyphs);
            }
        }
        return glyphs;
    }

    private int nextSignificantIndex() {
        int nextValidChar;
        for (nextValidChar = this.index; nextValidChar < this.text.length() && TextUtil.isWhitespaceOrNonPrintable(this.text.charAt(nextValidChar)); ++nextValidChar) {
        }
        return nextValidChar;
    }

    private MyCharacter.UnicodeScript nextSignificantUnicodeScript(int from) {
        for (int i = from; i < this.text.length(); ++i) {
            int codePoint;
            if (ComplexFontSelectorStrategy.isSurrogatePair(this.text, i)) {
                codePoint = TextUtil.convertToUtf32(this.text, i);
                ++i;
            } else {
                codePoint = this.text.charAt(i);
            }
            MyCharacter.UnicodeScript unicodeScript = MyCharacter.UnicodeScript.of(codePoint);
            if (!ComplexFontSelectorStrategy.isSignificantUnicodeScript(unicodeScript)) continue;
            return unicodeScript;
        }
        return MyCharacter.UnicodeScript.COMMON;
    }

    private static boolean isSignificantUnicodeScript(MyCharacter.UnicodeScript unicodeScript) {
        return unicodeScript != MyCharacter.UnicodeScript.COMMON && unicodeScript != MyCharacter.UnicodeScript.INHERITED;
    }

    private static boolean isSurrogatePair(String text, int idx) {
        return TextUtil.isSurrogateHigh(text.charAt(idx)) && idx < text.length() - 1 && TextUtil.isSurrogateLow(text.charAt(idx + 1));
    }
}

