/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.svg.exceptions.SvgProcessingException;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.path.IPathShape;
import cfca.sadk.com.itextpdf.svg.renderers.path.SvgPathShapeFactory;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.ClosePath;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.IControlPointCurve;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.MoveTo;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.QuadraticSmoothCurveTo;
import cfca.sadk.com.itextpdf.svg.renderers.path.impl.SmoothSCurveTo;
import cfca.sadk.com.itextpdf.svg.utils.SvgCssUtils;
import cfca.sadk.com.itextpdf.svg.utils.SvgRegexUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class PathSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private static final String SPACE_CHAR = " ";
    private static final String INVALID_OPERATOR_REGEX = "(?:(?![mzlhvcsqtae])\\p{L})";
    private static Pattern invalidRegexPattern = Pattern.compile("(?:(?![mzlhvcsqtae])\\p{L})", 2);
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?=[mlhvcsqtaz])", 2);
    private Point currentPoint = new Point(0, 0);
    private ClosePath zOperator = null;

    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% path\n");
        this.currentPoint = new Point(0, 0);
        for (IPathShape item : this.getShapes()) {
            item.draw(canvas);
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PathSvgNodeRenderer copy = new PathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    private String[] getShapeCoordinates(IPathShape shape, IPathShape previousShape, String[] pathProperties) {
        if (shape instanceof ClosePath) {
            return null;
        }
        String[] shapeCoordinates = null;
        if (shape instanceof SmoothSCurveTo || shape instanceof QuadraticSmoothCurveTo) {
            String[] startingControlPoint = new String[2];
            if (previousShape != null) {
                Point previousEndPoint = previousShape.getEndingPoint();
                if (previousShape instanceof IControlPointCurve) {
                    Point lastControlPoint = ((IControlPointCurve)((Object)previousShape)).getLastControlPoint();
                    float reflectedX = (float)(2.0 * previousEndPoint.getX() - lastControlPoint.getX());
                    float reflectedY = (float)(2.0 * previousEndPoint.getY() - lastControlPoint.getY());
                    startingControlPoint[0] = SvgCssUtils.convertFloatToString(reflectedX);
                    startingControlPoint[1] = SvgCssUtils.convertFloatToString(reflectedY);
                } else {
                    startingControlPoint[0] = SvgCssUtils.convertDoubleToString(previousEndPoint.getX());
                    startingControlPoint[1] = SvgCssUtils.convertDoubleToString(previousEndPoint.getY());
                }
            } else {
                startingControlPoint[0] = pathProperties[0];
                startingControlPoint[1] = pathProperties[1];
            }
            shapeCoordinates = PathSvgNodeRenderer.concatenate(startingControlPoint, pathProperties);
        }
        if (shapeCoordinates == null) {
            shapeCoordinates = pathProperties;
        }
        return shapeCoordinates;
    }

    private List<IPathShape> processPathOperator(String[] pathProperties, IPathShape previousShape) {
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        if (pathProperties.length == 0 || pathProperties[0].isEmpty() || SvgPathShapeFactory.getArgumentCount(pathProperties[0]) < 0) {
            return shapes;
        }
        int argumentCount = SvgPathShapeFactory.getArgumentCount(pathProperties[0]);
        if (argumentCount == 0) {
            if (previousShape == null) {
                throw new SvgProcessingException("The close path operator (Z) may not be used before a move to operation (M)");
            }
            shapes.add(this.zOperator);
            this.currentPoint = this.zOperator.getEndingPoint();
            return shapes;
        }
        for (int index = 1; index < pathProperties.length && index + argumentCount <= pathProperties.length; index += argumentCount) {
            IPathShape pathShape = SvgPathShapeFactory.createPathShape(pathProperties[0]);
            if (pathShape instanceof MoveTo) {
                shapes.addAll(this.addMoveToShapes(pathShape, pathProperties));
                return shapes;
            }
            String[] shapeCoordinates = this.getShapeCoordinates(pathShape, previousShape, Arrays.copyOfRange(pathProperties, index, index + argumentCount));
            if (pathShape != null) {
                if (shapeCoordinates != null) {
                    pathShape.setCoordinates(shapeCoordinates, this.currentPoint);
                }
                this.currentPoint = pathShape.getEndingPoint();
                shapes.add(pathShape);
            }
            previousShape = pathShape;
        }
        return shapes;
    }

    private List<IPathShape> addMoveToShapes(IPathShape pathShape, String[] pathProperties) {
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        int argumentCount = 2;
        String[] shapeCoordinates = this.getShapeCoordinates(pathShape, null, Arrays.copyOfRange(pathProperties, 1, 3));
        this.zOperator = new ClosePath(pathShape.isRelative());
        this.zOperator.setCoordinates(shapeCoordinates, this.currentPoint);
        pathShape.setCoordinates(shapeCoordinates, this.currentPoint);
        this.currentPoint = pathShape.getEndingPoint();
        shapes.add(pathShape);
        IPathShape previousShape = pathShape;
        if (pathProperties.length > 3) {
            for (int index = 3; index < pathProperties.length && index + 2 <= pathProperties.length; index += argumentCount) {
                pathShape = pathShape.isRelative() ? SvgPathShapeFactory.createPathShape("l") : SvgPathShapeFactory.createPathShape("L");
                shapeCoordinates = this.getShapeCoordinates(pathShape, previousShape, Arrays.copyOfRange(pathProperties, index, index + 2));
                pathShape.setCoordinates(shapeCoordinates, previousShape.getEndingPoint());
                shapes.add(pathShape);
                previousShape = pathShape;
            }
        }
        return shapes;
    }

    Collection<IPathShape> getShapes() {
        Collection<String> parsedResults = this.parsePathOperations();
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        for (String parsedResult : parsedResults) {
            String[] pathProperties = parsedResult.split(" +");
            IPathShape previousShape = shapes.size() == 0 ? null : (IPathShape)shapes.get(shapes.size() - 1);
            List<IPathShape> operatorShapes = this.processPathOperator(pathProperties, previousShape);
            shapes.addAll(operatorShapes);
        }
        return shapes;
    }

    private static String[] concatenate(String[] first, String[] second) {
        String[] arr = new String[first.length + second.length];
        System.arraycopy(first, 0, arr, 0, first.length);
        System.arraycopy(second, 0, arr, first.length, second.length);
        return arr;
    }

    boolean containsInvalidAttributes(String attributes) {
        return SvgRegexUtils.containsAtLeastOneMatch(invalidRegexPattern, attributes);
    }

    Collection<String> parsePathOperations() {
        String[] operators;
        ArrayList<String> result = new ArrayList<String>();
        String attributes = (String)this.attributesAndStyles.get("d");
        if (attributes == null) {
            throw new SvgProcessingException("A Path object must have an attribute with the name 'd'.");
        }
        if (this.containsInvalidAttributes(attributes)) {
            throw new SvgProcessingException("Invalid operators found in path data attribute: {0}").setMessageParams(attributes);
        }
        for (String inst : operators = PathSvgNodeRenderer.splitPathStringIntoOperators(attributes)) {
            String instTrim = inst.trim();
            if (instTrim.isEmpty()) continue;
            char instruction = instTrim.charAt(0);
            String temp = instruction + SPACE_CHAR + instTrim.substring(1).replace(",", SPACE_CHAR).trim();
            temp = this.separateDecimalPoints(temp);
            result.add(temp);
        }
        return result;
    }

    String separateDecimalPoints(String input) {
        StringBuilder res = new StringBuilder();
        boolean fractionalPartAfterDecimalPoint = false;
        boolean exponentSignMagnitude = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '-' || Character.isWhitespace(c)) {
                fractionalPartAfterDecimalPoint = false;
            }
            if (Character.isWhitespace(c)) {
                exponentSignMagnitude = false;
            }
            if (PathSvgNodeRenderer.endsWithNonWhitespace(res) && (c == '.' && fractionalPartAfterDecimalPoint || c == '-' && !exponentSignMagnitude)) {
                res.append(SPACE_CHAR);
            }
            if (c == '.') {
                fractionalPartAfterDecimalPoint = true;
            } else if (c == 'e') {
                exponentSignMagnitude = true;
            }
            res.append(c);
        }
        return res.toString();
    }

    static String[] splitPathStringIntoOperators(String path) {
        return SPLIT_PATTERN.split(path);
    }

    private static boolean endsWithNonWhitespace(StringBuilder sb) {
        return sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1));
    }
}

