/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.javax.net.ssl;

import cfca.sadk.tls.java.net.CFCAIDN;
import cfca.sadk.tls.java.nio.charset.CFCAStandardCharsets;
import cfca.sadk.tls.javax.net.ssl.CFCASNIMatcher;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.util.Utilities;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.regex.Pattern;

public final class CFCASNIHostName
extends CFCASNIServerName {
    private final String hostname;

    public CFCASNIHostName(String hostname) throws UnsupportedEncodingException {
        hostname = CFCAIDN.toASCII(Utilities.requireNonNull(hostname, "Server name value of host_name cannot be null"), 2);
        super(0, hostname.getBytes("US-ASCII"));
        this.hostname = hostname;
        this.checkHostName();
    }

    public CFCASNIHostName(byte[] encoded) {
        super(0, encoded);
        try {
            CharsetDecoder decoder = CFCAStandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.hostname = CFCAIDN.toASCII(decoder.decode(ByteBuffer.wrap(encoded)).toString());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The encoded server name value is invalid", e);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("The encoded server name value is invalid", e);
        }
        this.checkHostName();
    }

    public String getAsciiName() {
        return this.hostname;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CFCASNIHostName) {
            return this.hostname.equalsIgnoreCase(((CFCASNIHostName)other).hostname);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.hostname.toUpperCase(Locale.ENGLISH).hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "type=host_name (0), value=" + this.hostname;
    }

    public static CFCASNIMatcher createSNIMatcher(String regex) {
        if (regex == null) {
            throw new NullPointerException("The regular expression cannot be null");
        }
        return new SNIHostNameMatcher(regex);
    }

    private void checkHostName() {
        if (this.hostname.length() == 0) {
            throw new IllegalArgumentException("Server name value of host_name cannot be empty");
        }
        if (this.hostname.endsWith(".")) {
            throw new IllegalArgumentException("Server name value of host_name cannot have the trailing dot");
        }
    }

    private static final class SNIHostNameMatcher
    extends CFCASNIMatcher {
        private final Pattern pattern;

        SNIHostNameMatcher(String regex) {
            super(0);
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean matches(CFCASNIServerName serverName) {
            CFCASNIHostName hostname;
            if (serverName == null) {
                throw new NullPointerException("The SNIServerName argument cannot be null");
            }
            if (!(serverName instanceof CFCASNIHostName)) {
                if (serverName.getType() != 0) {
                    throw new IllegalArgumentException("The server name type is not host_name");
                }
                try {
                    hostname = new CFCASNIHostName(serverName.getEncoded());
                }
                catch (NullPointerException e) {
                    return false;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            } else {
                hostname = (CFCASNIHostName)serverName;
            }
            String asciiName = hostname.getAsciiName();
            if (this.pattern.matcher(asciiName).matches()) {
                return true;
            }
            return this.pattern.matcher(CFCAIDN.toUnicode(asciiName)).matches();
        }
    }
}

