/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.opentype.chaincontextsubst;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.SubTable;
import cfca.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.SubstLookupRecordList;
import cfca.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

public class ChainSubGenericRule
extends SubTable {
    public final NumRecordList backtrackGlyphs;
    public final NumRecordList inputClasses;
    public final NumRecordList lookAheadGlyphs;
    public final SubstLookupRecordList lookupRecords;

    protected ChainSubGenericRule(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data);
        this.backtrackGlyphs = new NumRecordList(data);
        this.inputClasses = new NumRecordList(data, 1, this.backtrackGlyphs.limit());
        this.lookAheadGlyphs = new NumRecordList(data, 0, this.inputClasses.limit());
        this.lookupRecords = new SubstLookupRecordList(data, this.lookAheadGlyphs.limit(), this.lookAheadGlyphs.limit() + 2);
    }

    static abstract class Builder<T extends ChainSubGenericRule>
    extends VisibleSubTable.Builder<T> {
        private NumRecordList backtrackGlyphsBuilder;
        private NumRecordList inputGlyphsBuilder;
        private NumRecordList lookAheadGlyphsBuilder;
        private SubstLookupRecordList lookupRecordsBuilder;

        protected Builder() {
        }

        protected Builder(ChainSubGenericRule table) {
            this(table.readFontData(), 0, false);
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.lookupRecordsBuilder != null) {
                this.serializedLength = this.lookupRecordsBuilder.limit();
            } else {
                this.computeSizeFromData(this.internalReadData());
            }
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.backtrackGlyphsBuilder == null || this.inputGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null || this.lookupRecordsBuilder == null) {
                return this.serializeFromData(newData);
            }
            return this.backtrackGlyphsBuilder.writeTo(newData) + this.inputGlyphsBuilder.writeTo(newData) + this.lookAheadGlyphsBuilder.writeTo(newData) + this.lookupRecordsBuilder.writeTo(newData);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.backtrackGlyphsBuilder = null;
            this.inputGlyphsBuilder = null;
            this.lookupRecordsBuilder = null;
            this.lookAheadGlyphsBuilder = null;
        }

        private void prepareToEdit() {
            this.initFromData(this.internalReadData());
            this.setModelChanged();
        }

        private void initFromData(ReadableFontData data) {
            if (this.backtrackGlyphsBuilder == null || this.inputGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null || this.lookupRecordsBuilder == null) {
                this.backtrackGlyphsBuilder = new NumRecordList(data);
                this.inputGlyphsBuilder = new NumRecordList(data, 0, this.backtrackGlyphsBuilder.limit());
                this.lookAheadGlyphsBuilder = new NumRecordList(data, 0, this.inputGlyphsBuilder.limit());
                this.lookupRecordsBuilder = new SubstLookupRecordList(data, this.lookAheadGlyphsBuilder.limit());
            }
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            if (data != null) {
                len = data.length();
            }
            this.serializedLength = len;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData();
            data.copyTo(newData);
            return data.length();
        }
    }
}

