/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.cert.assist;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.StringUtil;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustCertManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"environmentLogger");
    private static Map<String, X509Cert> trustCertDNMap = new ConcurrentHashMap<String, X509Cert>();
    private static String trustCertPath = "";

    public static void init(String trustCertDirPath) throws Exception {
        logger.info("Trustcert manager  init dir:{} start", (Object)trustCertDirPath);
        if (StringUtil.isEmpty(trustCertDirPath)) {
            throw new IllegalArgumentException("trustCertDirPath can not be empty");
        }
        File trustCertDirFile = new File(trustCertDirPath);
        if (!trustCertDirFile.exists()) {
            throw new CodeException("600802", "the trustCertDirPath : " + trustCertDirPath + " is not exist");
        }
        trustCertPath = trustCertDirPath;
        trustCertDNMap.clear();
        Collection trustCertFiles = FileUtils.listFiles((File)trustCertDirFile, (String[])new String[]{"cer"}, (boolean)false);
        if (trustCertFiles != null && trustCertFiles.size() > 0) {
            for (File trustCertFile : trustCertFiles) {
                try {
                    X509Cert x509Cert = new X509Cert((InputStream)new FileInputStream(trustCertFile));
                    trustCertDNMap.put(x509Cert.getSubject(), x509Cert);
                    logger.info("Trustcert manager add trust cert( dn:{})", (Object)x509Cert.getSubject());
                }
                catch (Exception e) {
                    logger.error("Trustcert manager add trustCert file({}) fail:", (Object)trustCertFile.getName());
                }
            }
        }
        logger.info("Trustcert manager init  trust cert size({}) successfully\n", (Object)trustCertDNMap.size());
        TrustCertManager.updateTrustCertsMap();
        SysEnv.loadTrustCerts((String)trustCertDirPath);
    }

    private static void updateTrustCertsMap() throws Exception {
        List<X509Cert> trustCerts = TrustCertManager.getTrustCertList();
        X509Cert[] trusCertsArray = new X509Cert[trustCerts.size()];
        trustCerts.toArray(trusCertsArray);
        X509CertVerifier.updateTrustCertsMap((X509Cert[])trusCertsArray);
    }

    public static void refresh() throws CodeException, Exception {
        TrustCertManager.init(trustCertPath);
    }

    public static X509Cert getTrustCertByDn(String dn) {
        return trustCertDNMap.get(dn);
    }

    public static List<X509Cert> getTrustCertList() throws Exception {
        ArrayList<X509Cert> list = new ArrayList<X509Cert>();
        for (Map.Entry<String, X509Cert> entry : trustCertDNMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }
}

