/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInfoUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"environmentLogger");
    private static String dbName = "";
    private static String dbVersion = "";

    public static void logBasicInfo() {
        List<String> environmentsList = EnvironmentInfoUtil.getBasicInfo();
        for (String envString : environmentsList) {
            logger.info(envString);
        }
    }

    public static List<String> getBasicInfo() {
        ArrayList<String> environmentsList = new ArrayList<String>();
        environmentsList.add("==================== Basic info start====================");
        EnvironmentInfoUtil.recordOSInfo(environmentsList);
        EnvironmentInfoUtil.recordJavaInfo(environmentsList);
        environmentsList.add("==================== Basic info end====================\n");
        return environmentsList;
    }

    public static void logDatabaseInfo(DataSource dataSource) throws Exception {
        List<String> environmentsList = EnvironmentInfoUtil.getDataBaseInfo(dataSource);
        for (String envString : environmentsList) {
            logger.info(envString);
        }
    }

    public static List<String> getDataBaseInfo(DataSource dataSource) throws Exception {
        ArrayList<String> environmentsList = new ArrayList<String>();
        environmentsList.add("==================== Database info start====================");
        EnvironmentInfoUtil.recordDatabaseInfo(environmentsList, dataSource);
        environmentsList.add("==================== Database info end====================\n");
        return environmentsList;
    }

    public static LinkedHashMap<String, String> recordSysInfoMap(DataSource dataSource) throws Exception {
        LinkedHashMap<String, String> osInfoMap = new LinkedHashMap<String, String>();
        osInfoMap.put("========OS==========", "==================\u64cd\u4f5c\u7cfb\u7edf\u4fe1\u606f==================");
        osInfoMap.put("os.name", System.getProperty("os.name"));
        osInfoMap.put("os.arch", System.getProperty("os.arch"));
        osInfoMap.put("os.version", System.getProperty("os.version"));
        osInfoMap.put("user.name", System.getProperty("user.name"));
        osInfoMap.put("user.home", System.getProperty("user.home"));
        osInfoMap.put("user.dir", System.getProperty("user.dir"));
        osInfoMap.put("user.timezone", System.getProperty("user.timezone"));
        osInfoMap.put("user.country", System.getProperty("user.country"));
        osInfoMap.put("user.language", System.getProperty("user.language"));
        osInfoMap.put("file.encoding", System.getProperty("file.encoding"));
        osInfoMap.put("========Java=========", "==================JDK\u4fe1\u606f======================");
        osInfoMap.put("java.home", System.getProperty("java.home"));
        osInfoMap.put("java.version", System.getProperty("java.version"));
        osInfoMap.put("java.vendor", System.getProperty("java.vendor"));
        osInfoMap.put("java.class.path", System.getProperty("java.class.path"));
        osInfoMap.put("========JVM=========", "==================JVM\u4fe1\u606f======================");
        osInfoMap.put("java.class.version", System.getProperty("java.class.version"));
        osInfoMap.put("java.library.path", System.getProperty("java.library.path"));
        osInfoMap.put("java.runtime.name", System.getProperty("java.runtime.name"));
        osInfoMap.put("java.runtime.version", System.getProperty("java.runtime.version"));
        osInfoMap.put("java.vm.vendor", System.getProperty("java.vm.vendor"));
        osInfoMap.put("sun.os.patch.level", System.getProperty("sun.os.patch.level"));
        osInfoMap.put("sun.arch.data.model", System.getProperty("sun.arch.data.model"));
        osInfoMap.put("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        osInfoMap.put("java.vm.name", System.getProperty("java.vm.name"));
        osInfoMap.put("java.vm.version", System.getProperty("java.vm.version"));
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        osInfoMap.put("JVM arguments(-D)", inputArguments.toString());
        if (dataSource == null) {
            return osInfoMap;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metadata = conn.getMetaData();
            String codeString = "";
            String selectSqlString = "SELECT CODE FROM ORGANIZATION WHERE CODE = ?";
            ps = conn.prepareStatement(selectSqlString);
            ps.setString(1, "001");
            rs = ps.executeQuery();
            if (rs.next()) {
                codeString = rs.getString("CODE");
            }
            rs.close();
            ps.close();
            osInfoMap.put("========DataBase=========", "==================\u6570\u636e\u5e93\u4fe1\u606f====================");
            osInfoMap.put("database.productName", metadata.getDatabaseProductName());
            osInfoMap.put("database.productVersion", metadata.getDatabaseProductVersion());
            osInfoMap.put("database.driverName", metadata.getDriverName());
            osInfoMap.put("database.driverVersion", metadata.getDriverVersion());
            osInfoMap.put("database.typeInfo", metadata.getTypeInfo().toString());
            osInfoMap.put("database.url", metadata.getURL());
            osInfoMap.put("database.userName", metadata.getUserName());
            osInfoMap.put("database.isReadOnly", metadata.isReadOnly() + "");
            osInfoMap.put("database.rootCode", codeString);
            LinkedHashMap<String, String> linkedHashMap = osInfoMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void recordOSInfo(List<String> environmentsList) {
        environmentsList.add(new StringBuffer().append("os.name").append(System.getProperty("os.name")).toString());
        environmentsList.add(new StringBuffer().append("os.arch: ").append(System.getProperty("os.arch")).toString());
        environmentsList.add(new StringBuffer().append("os.version: ").append(System.getProperty("os.version")).toString());
        environmentsList.add(new StringBuffer().append("user.name: ").append(System.getProperty("user.name")).toString());
        environmentsList.add(new StringBuffer().append("user.home: ").append(System.getProperty("user.home")).toString());
        environmentsList.add(new StringBuffer().append("user.dir: ").append(System.getProperty("user.dir")).toString());
        environmentsList.add(new StringBuffer().append("user.timezone: ").append(System.getProperty("user.timezone")).toString());
        environmentsList.add(new StringBuffer().append("user.country: ").append(System.getProperty("user.country")).toString());
        environmentsList.add(new StringBuffer().append("user.language: ").append(System.getProperty("user.language")).toString());
        environmentsList.add(new StringBuffer().append("file.encoding: ").append(System.getProperty("file.encoding")).toString());
    }

    public static HashMap<String, String> recordJavaInfoMap() {
        HashMap<String, String> javaInfoMap = new HashMap<String, String>();
        javaInfoMap.put("java.home", System.getProperty("java.home"));
        javaInfoMap.put("java.version", System.getProperty("java.version"));
        javaInfoMap.put("java.vendor", System.getProperty("java.vendor"));
        javaInfoMap.put("java.class.path", System.getProperty("java.class.path"));
        javaInfoMap.put("java.library.path", System.getProperty("java.library.path"));
        javaInfoMap.put("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        javaInfoMap.put("java.vm.name", System.getProperty("java.vm.name"));
        javaInfoMap.put("java.vm.version", System.getProperty("java.vm.version"));
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        javaInfoMap.put("JVM arguments(-D)", inputArguments.toString());
        return javaInfoMap;
    }

    public static void recordJavaInfo(List<String> environmentsList) {
        environmentsList.add(new StringBuffer().append("java.home: ").append(System.getProperty("java.home")).toString());
        environmentsList.add(new StringBuffer().append("java.version: ").append(System.getProperty("java.version")).toString());
        environmentsList.add(new StringBuffer().append("java.vendor: ").append(System.getProperty("java.vendor")).toString());
        environmentsList.add(new StringBuffer().append("java.class.path: ").append(System.getProperty("java.class.path")).toString());
        environmentsList.add(new StringBuffer().append("java.library.path: ").append(System.getProperty("java.library.path")).toString());
        environmentsList.add(new StringBuffer().append("java.io.tmpdir: ").append(System.getProperty("java.io.tmpdir")).toString());
        environmentsList.add(new StringBuffer().append("java.vm.name: ").append(System.getProperty("java.vm.name")).toString());
        environmentsList.add(new StringBuffer().append("java.vm.version: ").append(System.getProperty("java.vm.version")).toString());
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        environmentsList.add(new StringBuffer().append("JVM arguments(-D): ").append(inputArguments).toString());
    }

    public static void recordDatabaseInfo(List<String> environmentsList, DataSource dataSource) throws Exception {
        if (dataSource == null) {
            return;
        }
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metadata = conn.getMetaData();
            String codeString = "";
            String selectSqlString = "SELECT ID FROM ORGANIZATION WHERE ID = ?";
            ps = conn.prepareStatement(selectSqlString);
            ps.setString(1, "0");
            rs = ps.executeQuery();
            if (rs.next()) {
                codeString = rs.getString("ID");
            }
            rs.close();
            ps.close();
            dbName = metadata.getDatabaseProductName();
            dbVersion = metadata.getDatabaseProductVersion();
            environmentsList.add(new StringBuffer().append("database.productName: ").append(metadata.getDatabaseProductName()).toString());
            environmentsList.add(new StringBuffer().append("database.productVersion: ").append(metadata.getDatabaseProductVersion()).toString());
            environmentsList.add(new StringBuffer().append("database.driverName: ").append(metadata.getDriverName()).toString());
            environmentsList.add(new StringBuffer().append("database.driverVersion: ").append(metadata.getDriverVersion()).toString());
            environmentsList.add(new StringBuffer().append("database.typeInfo: ").append(metadata.getTypeInfo()).toString());
            environmentsList.add(new StringBuffer().append("database.url: ").append(metadata.getURL()).toString());
            environmentsList.add(new StringBuffer().append("database.userName: ").append(metadata.getUserName()).toString());
            environmentsList.add(new StringBuffer().append("database.isReadOnly: ").append(metadata.isReadOnly()).toString());
            environmentsList.add(new StringBuffer().append("database.rootID: ").append(codeString).toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static void logProductInfo(String productName, String version) {
        logger.info("==================== Product info start====================");
        logger.info("Product Name:{}", (Object)productName);
        logger.info("Product Version:{}", (Object)version);
        logger.info("==================== Product info end====================\n");
    }

    public static String getDbName() {
        return dbName;
    }

    public static String getDbVersion() {
        return dbVersion;
    }
}

