/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"environmentLogger");

    public static String getRequestIpAddress(HttpServletRequest request) {
        String ip;
        block7: {
            block6: {
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block6;
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block7;
                ip = request.getRemoteAddr();
                break block7;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if ("unknown".equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public static List<String> getLocalHostLANAddress() throws UnknownHostException {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (!ni.isUp() || ni.isLoopback()) {
                    logger.info("ni.isUp():" + ni.isUp() + "ni.isLoopback:" + ni.isLoopback());
                    continue;
                }
                Enumeration<InetAddress> ipAddrEnum = ni.getInetAddresses();
                while (ipAddrEnum.hasMoreElements()) {
                    InetAddress addr = ipAddrEnum.nextElement();
                    if (addr.isLoopbackAddress() || addr.isLinkLocalAddress()) {
                        logger.info("ni.isLoopbackAddress():" + addr.isLoopbackAddress() + "ni.isLinkLocalAddress:" + addr.isLinkLocalAddress());
                        continue;
                    }
                    String ip = addr.getHostAddress();
                    logger.info("ip:" + ip);
                    if (ip.indexOf(":") != -1) continue;
                    ipList.add(ip);
                }
            }
            Collections.sort(ipList);
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e.getMessage());
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
        if (ipList.isEmpty()) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address");
            throw unknownHostException;
        }
        String hostAddress = "";
        try {
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            hostAddress = jdkSuppliedAddress.getHostAddress();
            logger.info("hostAddress:" + hostAddress);
        }
        catch (UnknownHostException e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e.getMessage());
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
        if (null == hostAddress || hostAddress.trim().length() == 0 || "127.0.0.1".equals(hostAddress) || "localhost".equalsIgnoreCase(hostAddress) || "unknown".equalsIgnoreCase(hostAddress)) {
            return ipList;
        }
        if (ipList.contains(hostAddress)) {
            ArrayList<String> targetIpList = new ArrayList<String>();
            targetIpList.add(hostAddress);
            logger.info("ipList.contains(hostAddress)");
            return targetIpList;
        }
        return ipList;
    }
}

