/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.util.IoUtil;
import java.io.IOException;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketProxyUtil {
    private static final Logger logger = LoggerFactory.getLogger(SocketProxyUtil.class);
    public static final int DEFAUL_CONNECT_TIME_OUT = 5000;
    public static final int DEFAUL_READ_TIME_OUT = 30000;

    public static String sendAndGetResponse(String requestXML, String host, int port, int connectTimeout, int readTimeout) throws Exception {
        Socket socket = null;
        String responseXML = "";
        try {
            socket = IoUtil.createSocket(host, port, connectTimeout, readTimeout);
            logger.info("send request xml by socket for local port:{}", (Object)socket.getLocalPort());
            IoUtil.sendLengthValue(socket.getOutputStream(), requestXML.getBytes("UTF-8"));
            responseXML = new String(IoUtil.readLengthValue(socket.getInputStream()), "UTF-8");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return responseXML;
    }

    public static String sendAndGetResponse(String requestXML, String host, int port) throws Exception {
        return SocketProxyUtil.sendAndGetResponse(requestXML, host, port, 5000, 30000);
    }
}

