/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.connector;

import cfca.paperless.client.util.CommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpClient {
    public static final String BOUNDARY = UUID.randomUUID().toString();
    public static final String PREFIX = "--------";
    public static final String LINEND = "\r\n";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    public static final int DEFAULT_READ_TIMEOUT = 30000;
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final String DEFAULT_KEY_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_KEY_STORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_TRUST_ALGORITHM = TrustManagerFactory.getDefaultAlgorithm();
    public static final String DEFAULT_TRUST_STORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_HTTP_USER_AGENT = "Client";
    public static final String DEFAULT_HTTP_CONNECTION = "Close";
    public static final String DEFAULT_HTTP_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_HTTP_ACCEPT = "text/plain";
    private static HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    public Config config = new Config();
    public SSLConfig sslConfig = new SSLConfig();
    public HttpConfig httpConfig = new HttpConfig();
    private SSLSocketFactory sslSocketFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSSL(String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) throws GeneralSecurityException, IOException {
        FileInputStream fileInputStream;
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = null;
        if (CommonUtil.isNotEmpty(keyStorePath)) {
            KeyManagerFactory keyManagerFactory = null;
            KeyStore keyStore = null;
            if (CommonUtil.isEmpty(this.sslConfig.keyProvider)) {
                keyManagerFactory = KeyManagerFactory.getInstance(this.sslConfig.keyAlgorithm);
                if (CommonUtil.isNotEmpty(this.sslConfig.keyStoreType)) {
                    keyStore = KeyStore.getInstance(this.sslConfig.keyStoreType);
                }
            } else {
                keyManagerFactory = KeyManagerFactory.getInstance(this.sslConfig.keyAlgorithm, this.sslConfig.keyProvider);
                if (CommonUtil.isNotEmpty(this.sslConfig.keyStoreType)) {
                    keyStore = KeyStore.getInstance(this.sslConfig.keyStoreType, this.sslConfig.keyProvider);
                }
            }
            fileInputStream = null;
            try {
                char[] keyStorePasswordCharArray = CommonUtil.isNotEmpty(keyStorePassword) ? keyStorePassword.toCharArray() : new char[]{};
                fileInputStream = new FileInputStream(keyStorePath);
                keyStore.load(fileInputStream, keyStorePasswordCharArray);
                keyManagerFactory.init(keyStore, keyStorePasswordCharArray);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        if (CommonUtil.isNotEmpty(trustStorePath)) {
            TrustManagerFactory trustManagerFactory = null;
            KeyStore trustStore = null;
            if (CommonUtil.isEmpty(this.sslConfig.trustProvider)) {
                trustManagerFactory = TrustManagerFactory.getInstance(this.sslConfig.trustAlgorithm);
                if (CommonUtil.isNotEmpty(this.sslConfig.trustStoreType)) {
                    trustStore = KeyStore.getInstance(this.sslConfig.trustStoreType);
                }
            } else {
                trustManagerFactory = TrustManagerFactory.getInstance(this.sslConfig.trustAlgorithm, this.sslConfig.trustProvider);
                if (CommonUtil.isNotEmpty(this.sslConfig.trustStoreType)) {
                    trustStore = KeyStore.getInstance(this.sslConfig.trustStoreType, this.sslConfig.trustProvider);
                }
            }
            fileInputStream = null;
            try {
                char[] trustStorePasswordCharArray = CommonUtil.isNotEmpty(trustStorePassword) ? trustStorePassword.toCharArray() : new char[]{};
                fileInputStream = new FileInputStream(trustStorePath);
                trustStore.load(fileInputStream, trustStorePasswordCharArray);
                trustManagerFactory.init(trustStore);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            trustManagerArray = trustManagerFactory.getTrustManagers();
        }
        SSLContext sslContext = null;
        sslContext = CommonUtil.isEmpty(this.sslConfig.sslProvider) ? SSLContext.getInstance(this.sslConfig.sslProtocol) : SSLContext.getInstance(this.sslConfig.sslProtocol, this.sslConfig.sslProvider);
        sslContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        this.sslSocketFactory = sslContext.getSocketFactory();
    }

    public HttpURLConnection connect(String url, String method, Map<String, String> headersMap) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        if (this.sslSocketFactory != null) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            httpsConn.setSSLSocketFactory(this.sslSocketFactory);
            if (this.sslConfig.ignoreHostname) {
                httpsConn.setHostnameVerifier(ignoreHostnameVerifier);
            }
        }
        connection.setConnectTimeout(this.config.connectTimeout);
        connection.setReadTimeout(this.config.readTimeout);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(method);
        connection.setRequestProperty("User-Agent", this.httpConfig.userAgent);
        connection.setRequestProperty("Connection", this.httpConfig.connection);
        connection.setRequestProperty("Content-Type", this.httpConfig.contentType + ";charset=" + this.config.charset);
        connection.setRequestProperty("Accept", this.httpConfig.accept);
        connection.setRequestProperty("Accept-Charset", this.config.charset);
        if (CommonUtil.isNotEmpty(headersMap)) {
            for (Map.Entry<String, String> pair : headersMap.entrySet()) {
                if (CommonUtil.isEmpty(pair.getKey())) continue;
                connection.setRequestProperty(pair.getKey(), pair.getValue());
            }
        }
        return connection;
    }

    public void send(HttpURLConnection connection, byte[] requestData) throws IOException {
        if (requestData != null) {
            connection.setFixedLengthStreamingMode(requestData.length);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(requestData);
            outputStream.flush();
        } else {
            connection.connect();
        }
    }

    public void parseHttpHeaders(HttpURLConnection connection, Map<String, String> responseHttpHeadersMap) {
        if (CommonUtil.isNotEmpty(responseHttpHeadersMap)) {
            for (Map.Entry<String, String> pair : responseHttpHeadersMap.entrySet()) {
                if (CommonUtil.isEmpty(pair.getKey())) continue;
                String value = connection.getHeaderField(pair.getKey());
                pair.setValue(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] receive(HttpURLConnection connection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                inputStream = connection.getInputStream();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.config.bufferSize);
            byte[] buffer = new byte[this.config.bufferSize];
            int read = -1;
            while ((read = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, read);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void disconnect(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static class HttpConfig {
        public String userAgent = "Client";
        public String connection = "Close";
        public String contentType = "text/plain";
        public String accept = "text/plain";
    }

    public static class SSLConfig {
        public String sslProvider = null;
        public String sslProtocol = "TLSv1.2";
        public String keyProvider = null;
        public String keyAlgorithm = DEFAULT_KEY_ALGORITHM;
        public String keyStoreType = DEFAULT_KEY_STORE_TYPE;
        public String trustProvider = null;
        public String trustAlgorithm = DEFAULT_TRUST_ALGORITHM;
        public String trustStoreType = DEFAULT_TRUST_STORE_TYPE;
        public boolean ignoreHostname = true;
    }

    public static class Config {
        public String charset = "UTF-8";
        public int bufferSize = 4096;
        public int connectTimeout = 3000;
        public int readTimeout = 30000;
    }
}

