/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardBigIntegers;

public final class SM2CardDataFormat {
    private SM2CardDataFormat() {
    }

    public static byte[] convertToCardEncryptData(byte[] c1c3c2RawEncryptData) throws CryptoException {
        int fixedLength = 96;
        if (c1c3c2RawEncryptData == null || c1c3c2RawEncryptData.length < 96) {
            throw new CryptoException("convertCardEncryptData failed: param encryptData is null/not enough length");
        }
        int cipherDataLength = c1c3c2RawEncryptData.length - 96;
        byte[] cardEncryptData = new byte[4 + c1c3c2RawEncryptData.length];
        int offset = 0;
        System.arraycopy(c1c3c2RawEncryptData, 0, cardEncryptData, 0, 96);
        offset += 96;
        offset += SM2CardBigIntegers.copyLength(cipherDataLength, cardEncryptData, offset);
        System.arraycopy(c1c3c2RawEncryptData, 96, cardEncryptData, offset, cipherDataLength);
        return cardEncryptData;
    }

    public static byte[] convertToC1C3C2RAWEncryptData(byte[] cardEncryptData) throws CryptoException {
        int cardFixedLength = 100;
        if (cardEncryptData == null || cardEncryptData.length < 100) {
            throw new CryptoException("convertRAWC1C3C2EncryptData failed: param cardEncryptData is null/not enough length");
        }
        int cipherDataLength = cardEncryptData.length - 100;
        int length = SM2CardBigIntegers.parseInt(cardEncryptData, 96);
        if (length != cipherDataLength) {
            throw new CryptoException("convertRAWC1C3C2EncryptData failed: param cardEncryptData invalid/not match");
        }
        int rawFixedLength = 96;
        byte[] rawEncryptData = new byte[cardEncryptData.length - 4];
        int offset = 0;
        System.arraycopy(cardEncryptData, 0, rawEncryptData, 0, 96);
        offset += 96;
        System.arraycopy(cardEncryptData, offset += 4, rawEncryptData, 96, cipherDataLength);
        return rawEncryptData;
    }
}

