/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.security.PublicKey;
import org.apache.http.util.Args;

public final class TSACertHolder
extends X509CertificateHolder {
    public static final int CERT_TYPE_UNKNOWN = -1;
    public static final int CERT_TYPE_SM2CERT = 1;
    public static final int CERT_TYPE_RSACERT = 2;
    private static final int SM2_PUBLIC_KEY_RAW_LENGTH = 64;
    private static final int SM2_PUBLIC_KEY_RAW_LENGTH_WITH_04 = 65;
    private byte[] encoding = null;
    private PublicKey publicKey;
    private int certType = -1;

    public TSACertHolder(byte[] certEncoding) throws IOException {
        super(certEncoding);
        this.encoding = certEncoding == null ? null : (byte[])certEncoding.clone();
    }

    public TSACertHolder(Certificate x509Certificate) {
        super(x509Certificate);
    }

    public static TSACertHolder from(X509CertificateHolder x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("missing x509Cert");
        }
        return new TSACertHolder(x509Cert.toASN1Structure());
    }

    public static TSACertHolder from(X509Cert x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("missing x509Cert");
        }
        TSACertHolder holder = new TSACertHolder(x509Cert.getCertStructure());
        holder.encoding = x509Cert.getEncoding();
        return holder;
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoding == null) {
            this.encoding = super.getEncoded();
        }
        return this.encoding;
    }

    public PublicKey getPublicKey() throws PKIException {
        if (this.publicKey == null) {
            PublicKey publicKey;
            this.publicKey = publicKey = this.buildPublicKey(this.toASN1Structure());
        }
        return this.publicKey;
    }

    public boolean isSM2Cert() {
        this.buildCertType();
        return this.certType == 1;
    }

    public boolean isRSACert() {
        this.buildCertType();
        return this.certType == 2;
    }

    private final PublicKey buildPublicKey(Certificate cert) throws PKIException {
        Args.notNull((Object)cert, (String)"cert");
        this.buildCertType();
        SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
        PublicKey publicKey = null;
        switch (this.certType) {
            case 1: {
                publicKey = this.buildSM2PublicKey(subjectPublicKeyInfo);
                break;
            }
            case 2: {
                publicKey = this.buildRSAPublicKey(subjectPublicKeyInfo);
                break;
            }
            default: {
                throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
            }
        }
        return publicKey;
    }

    private boolean isSM2PubKeyDataValid(byte[] pubData) {
        return pubData != null && (pubData.length == 64 || pubData.length == 65);
    }

    private PublicKey buildSM2PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        Args.notNull((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
        try {
            byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
            boolean pubDataValid = this.isSM2PubKeyDataValid(pubData);
            if (!pubDataValid) {
                throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
            }
            int starter = pubData.length == 65 ? 1 : 0;
            int len = 32;
            byte[] pubX = new byte[32];
            byte[] pubY = new byte[32];
            System.arraycopy(pubData, starter, pubX, 0, 32);
            System.arraycopy(pubData, starter + 32, pubY, 0, 32);
            return new SM2PublicKey(pubX, pubY);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.SPKI_KEY, "Convert SubjectPublicKeyInfo TO SM2PubKey Failed", (Throwable)e);
        }
    }

    private PublicKey buildRSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        Args.notNull((Object)subjectPublicKeyInfo, (String)"subjectPublicKeyInfo");
        try {
            RSAPublicKey pubKey = RSAPublicKey.getInstance((Object)subjectPublicKeyInfo.parsePublicKey());
            RSAKeyParameters param = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
            return new BCRSAPublicKey(param);
        }
        catch (IOException e) {
            throw new PKIException(PKIException.SPKI_KEY, "Convert SubjectPublicKeyInfo TO RSAPubKey Failed", (Throwable)e);
        }
    }

    private final int buildCertType() {
        if (this.certType == -1) {
            int certType = 0;
            Certificate cert = this.toASN1Structure();
            if (cert != null) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                AlgorithmIdentifier algorithm = subjectPublicKeyInfo.getAlgorithm();
                String keyTypeAlgorithmId = algorithm.getAlgorithm().getId();
                if (keyTypeAlgorithmId.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                    certType = 2;
                } else if (keyTypeAlgorithmId.equals(GMObjectIdentifiers.ecPubKey.getId())) {
                    ASN1Encodable parameters = algorithm.getParameters();
                    if (parameters != null && parameters instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier param = (ASN1ObjectIdentifier)parameters;
                        if (param.equals((Object)GMObjectIdentifiers.sm2_old)) {
                            certType = 1;
                        } else if (param.equals((Object)GMObjectIdentifiers.sm2PubKey)) {
                            certType = 1;
                        }
                    }
                    if (certType != 1) {
                        String signAlgorithmId = cert.getSignatureAlgorithm().getAlgorithm().getId();
                        if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption.getId())) {
                            certType = 1;
                        } else if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId())) {
                            certType = 1;
                        }
                    }
                }
                this.certType = certType;
            }
        }
        return this.certType;
    }

    public X509Cert getX509Cert() {
        return new X509Cert(this.toASN1Structure());
    }
}

