/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.PrivateKeyFactory;
import cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class RSAKeyParamsDecoder {
    private RSAKeyParamsDecoder() {
    }

    public static RSAKeyParameters generatePublicKeyParameter(PublicKey publicKey) throws Exception {
        if (publicKey == null) {
            throw new Exception("the publicKey is null,can not generate PublicKeyParameter!!!");
        }
        RSAKeyParameters params = null;
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)publicKey;
            params = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        } else {
            byte[] encoding = null;
            try {
                encoding = publicKey.getEncoded();
                SubjectPublicKeyInfo pubKeyInfo = SubjectPublicKeyInfo.getInstance(encoding);
                params = (RSAKeyParameters)PublicKeyFactory.createKey(pubKeyInfo);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("the publicKey invalid format,can not generate PublicKeyParameter: {}", (Object)Hex.toHexString(encoding), (Object)e);
                throw new Exception("the publicKey invalid format,can not generate PublicKeyParameter ", e);
            }
        }
        return params;
    }

    public static RSAKeyParameters generatePrivateKeyParameter(PrivateKey privateKey) throws Exception {
        if (privateKey == null) {
            throw new Exception("the privateKey is null,can not decrypt");
        }
        RSAKeyParameters params = null;
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)privateKey;
            BigInteger primeP = k.getPrimeP();
            BigInteger primeQ = k.getPrimeQ();
            params = BigInteger.ZERO.equals(primeP) || BigInteger.ZERO.equals(primeQ) ? new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent()) : new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), primeP, primeQ, k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        } else if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)privateKey;
            params = new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent());
        } else {
            byte[] encoding = null;
            try {
                encoding = privateKey.getEncoded();
                params = (RSAKeyParameters)PrivateKeyFactory.createKey(encoding);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("the privateKey invalid format,can not generate PrivateKeyParameter: {}", (Object)Hex.toHexString(encoding), (Object)e);
                throw new Exception("the privateKey invalid format,can not generate PrivateKeyParameter ", e);
            }
        }
        return params;
    }
}

