/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf;

import cfca.sadk.com.itextpdf.kernel.pdf.PdfDate;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObjectWrapper;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import java.util.Map;

public class PdfDocumentInfo
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = -21957940280527123L;

    public PdfDocumentInfo(PdfDictionary pdfObject, PdfDocument pdfDocument) {
        super(pdfObject == null ? new PdfDictionary() : pdfObject);
        if (pdfDocument.getWriter() != null) {
            ((PdfDictionary)this.getPdfObject()).makeIndirect(pdfDocument);
        }
        this.setForbidRelease();
    }

    public PdfDocumentInfo(PdfDictionary pdfObject) {
        this(pdfObject, null);
    }

    public PdfDocumentInfo(PdfDocument pdfDocument) {
        this(new PdfDictionary(), pdfDocument);
    }

    public PdfDocumentInfo setTitle(String title) {
        return this.put(PdfName.Title, new PdfString(title, "UnicodeBig"));
    }

    public PdfDocumentInfo setAuthor(String author) {
        return this.put(PdfName.Author, new PdfString(author, "UnicodeBig"));
    }

    public PdfDocumentInfo setSubject(String subject) {
        return this.put(PdfName.Subject, new PdfString(subject, "UnicodeBig"));
    }

    public PdfDocumentInfo setKeywords(String keywords) {
        return this.put(PdfName.Keywords, new PdfString(keywords, "UnicodeBig"));
    }

    public PdfDocumentInfo setCreator(String creator) {
        return this.put(PdfName.Creator, new PdfString(creator, "UnicodeBig"));
    }

    public String getTitle() {
        return this.getStringValue(PdfName.Title);
    }

    public String getAuthor() {
        return this.getStringValue(PdfName.Author);
    }

    public String getSubject() {
        return this.getStringValue(PdfName.Subject);
    }

    public String getKeywords() {
        return this.getStringValue(PdfName.Keywords);
    }

    public String getCreator() {
        return this.getStringValue(PdfName.Creator);
    }

    public String getProducer() {
        return this.getStringValue(PdfName.Producer);
    }

    public PdfDocumentInfo addCreationDate() {
        return this.put(PdfName.CreationDate, (PdfObject)new PdfDate().getPdfObject());
    }

    public PdfDocumentInfo addModDate() {
        return this.put(PdfName.ModDate, (PdfObject)new PdfDate().getPdfObject());
    }

    public void setMoreInfo(Map<String, String> moreInfo) {
        if (moreInfo != null) {
            for (Map.Entry<String, String> entry : moreInfo.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.setMoreInfo(key, value);
            }
        }
    }

    public void setMoreInfo(String key, String value) {
        PdfName keyName = new PdfName(key);
        if (value == null) {
            ((PdfDictionary)this.getPdfObject()).remove(keyName);
            this.setModified();
        } else {
            this.put(keyName, new PdfString(value, "UnicodeBig"));
        }
    }

    @Override
    public void flush() {
        ((PdfDictionary)this.getPdfObject()).flush(false);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    private String getStringValue(PdfName name) {
        PdfString pdfString = ((PdfDictionary)this.getPdfObject()).getAsString(name);
        return pdfString != null ? pdfString.toUnicodeString() : null;
    }

    private PdfDocumentInfo put(PdfName key, PdfObject value) {
        ((PdfDictionary)this.getPdfObject()).put(key, value);
        this.setModified();
        return this;
    }
}

