/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.svg.renderers.impl;

import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import cfca.sadk.com.itextpdf.styledxmlparser.css.util.CssUtils;
import cfca.sadk.com.itextpdf.svg.exceptions.SvgProcessingException;
import cfca.sadk.com.itextpdf.svg.renderers.ISvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.SvgDrawContext;
import cfca.sadk.com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import cfca.sadk.com.itextpdf.svg.renderers.impl.SvgNodeUtil;
import cfca.sadk.com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.List;

public class PolylineSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    protected List<Point> points = new ArrayList<Point>();

    protected List<Point> getPoints() {
        return this.points;
    }

    protected void setPoints(String pointsAttribute) {
        if (pointsAttribute == null) {
            return;
        }
        List<String> points = SvgCssUtils.splitValueList(pointsAttribute);
        if (points.size() % 2 != 0) {
            throw new SvgProcessingException("Points attribute {0} on polyline tag does not contain a valid set of points").setMessageParams(pointsAttribute);
        }
        for (int i = 0; i < points.size(); i += 2) {
            float x = CssUtils.parseAbsoluteLength(points.get(i));
            float y = CssUtils.parseAbsoluteLength(points.get(i + 1));
            this.points.add(new Point(x, y));
        }
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        String pointsAttribute = this.attributesAndStyles.containsKey("points") ? (String)this.attributesAndStyles.get("points") : null;
        this.setPoints(pointsAttribute);
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% polyline\n");
        if (this.points.size() > 1) {
            float[] startPoint = SvgNodeUtil.getStartPoint(this);
            float absoluteX = CssUtils.parseAbsoluteLength(String.valueOf(startPoint[0]));
            float absoluteY = CssUtils.parseAbsoluteLength(String.valueOf(startPoint[1]));
            Point currentPoint = this.points.get(0);
            canvas.moveTo(currentPoint.getX() - (double)absoluteX, currentPoint.getY() - (double)absoluteY);
            canvas.saveState();
            String opacity = (String)this.attributesAndStyles.get("opacity");
            PdfExtGState extGState = new PdfExtGState();
            float strokeOpacity = Float.valueOf(opacity).floatValue();
            extGState.setStrokeOpacity(strokeOpacity * strokeOpacity);
            canvas.setExtGState(extGState);
            canvas.restoreState();
            for (int x = 1; x < this.points.size(); ++x) {
                currentPoint = this.points.get(x);
                canvas.lineTo(currentPoint.getX() - (double)absoluteX, currentPoint.getY() - (double)absoluteY);
            }
        }
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PolylineSvgNodeRenderer copy = new PolylineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

