/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.sample.sfview;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.FontFactory;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.table.core.PostScriptTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.GlyphGroup;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.Rule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class GsubRulesDump {
    public static void main(String[] args) throws IOException {
        String fontName = args[0];
        String txt = args[1];
        System.out.println("Rules from font: " + fontName);
        Font[] fonts = GsubRulesDump.loadFont(new File(fontName));
        if (fonts == null) {
            throw new IllegalArgumentException("No font found");
        }
        Font font = fonts[0];
        GlyphGroup ruleClosure = Rule.charGlyphClosure(font, txt);
        PostScriptTable post = (PostScriptTable)font.getTable(Tag.post);
        Rule.dumpLookups(font);
        System.out.println("Closure: " + ruleClosure.toString(post));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font[] loadFont(File file) throws IOException {
        FontFactory fontFactory = FontFactory.getInstance();
        fontFactory.fingerprintFont(true);
        FileInputStream is = new FileInputStream(file);
        try {
            Font[] fontArray = fontFactory.loadFonts(is);
            return fontArray;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not load the font: " + file.getName());
            Font[] fontArray = null;
            return fontArray;
        }
        finally {
            is.close();
        }
    }
}

