/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.signatures.PdfSigner;
import cfca.sadk.seal.base.bean.appearance.AbstractAppearance;
import cfca.sadk.seal.base.bean.appearance.BlankAppearance;
import cfca.sadk.seal.base.bean.appearance.GraphicAppearance;
import cfca.sadk.seal.base.bean.appearance.TextAppearance;
import cfca.sadk.seal.base.bean.sign.SealResultInfo;
import cfca.sadk.seal.base.bean.sign.SignInfoConfig;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.util.SealSignatureUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class AsyncSignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(AsyncSignatureUtil.class);

    public static SealResultInfo createBlankSignature(byte[] sourceData, AbstractAppearance appearance, SignInfoConfig signatureConfig) throws SealException {
        businessLog.info("createBlankSignature begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("createBlankSignature");
        ParamsCheckUtil.checkSignParams(sourceData, appearance, signatureConfig);
        try {
            SealResultInfo result = null;
            if (appearance instanceof GraphicAppearance) {
                result = SealSignatureUtil.signGraphic(sourceData, (GraphicAppearance)appearance, signatureConfig);
            } else if (appearance instanceof BlankAppearance) {
                result = SealSignatureUtil.signBlank(sourceData, (BlankAppearance)appearance, signatureConfig);
            } else if (appearance instanceof TextAppearance) {
                result = SealSignatureUtil.signText(sourceData, (TextAppearance)appearance, signatureConfig);
            }
            SealResultInfo sealResultInfo = result;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("createBlankSignature: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearance, e});
            throw e;
        }
        catch (Exception e) {
            businessLog.error("createBlankSignature: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearance, e});
            throw new SealException("createBlankSignature failed:", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("createBlankSignature end...");
        }
    }

    public static SealResultInfo signKeyword(InputStream inputStream, OutputStream outputStream, GraphicAppearance appearance, SignInfoConfig signInfo, String keyword, boolean replaceSpace) throws SealException {
        businessLog.info("signKeyword begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signKeyword");
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            byte[] sourceData = IOUtils.toByteArray((InputStream)inputStream);
            SealResultInfo sealResultInfo = SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword, replaceSpace);
            byte[] signedData = sealResultInfo.getSignedPDFData();
            IOUtils.write((byte[])signedData, (OutputStream)outputStream);
            businessLog.info("signKeyword end...");
            SealResultInfo sealResultInfo2 = sealResultInfo;
            return sealResultInfo2;
        }
        catch (IOException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            businessLog.info("signKeyword: in and out stream closed.");
            MethodCostTimeUtil.recordEndTime(methodName);
        }
    }

    public static SealResultInfo signKeyword(InputStream inputStream, OutputStream outputStream, GraphicAppearance appearance, SignInfoConfig signInfo, String keyword) throws SealException {
        businessLog.info("signKeyword begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signKeyword");
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            byte[] sourceData = IOUtils.toByteArray((InputStream)inputStream);
            SealResultInfo sealResultInfo = SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword);
            byte[] signedData = sealResultInfo.getSignedPDFData();
            IOUtils.write((byte[])signedData, (OutputStream)outputStream);
            businessLog.info("signKeyword end...");
            SealResultInfo sealResultInfo2 = sealResultInfo;
            return sealResultInfo2;
        }
        catch (IOException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            businessLog.info("signKeyword: in and out stream closed.");
            MethodCostTimeUtil.recordEndTime(methodName);
        }
    }

    public static SealResultInfo signKeyword(InputStream inputStream, OutputStream outputStream, TextAppearance appearance, SignInfoConfig signInfo, String keyword) throws SealException {
        businessLog.info("signKeyword begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signKeyword");
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            byte[] sourceData = IOUtils.toByteArray((InputStream)inputStream);
            SealResultInfo sealResultInfo = SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword);
            byte[] signedData = sealResultInfo.getSignedPDFData();
            IOUtils.write((byte[])signedData, (OutputStream)outputStream);
            businessLog.info("signKeyword end...");
            SealResultInfo sealResultInfo2 = sealResultInfo;
            return sealResultInfo2;
        }
        catch (IOException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            businessLog.info("signKeyword: in and out stream closed.");
            MethodCostTimeUtil.recordEndTime(methodName);
        }
    }

    public static SealResultInfo signKeyword(InputStream inputStream, OutputStream outputStream, TextAppearance appearance, SignInfoConfig signInfo, String keyword, boolean replaceSpace) throws SealException {
        businessLog.info("signKeyword begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signKeyword");
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            byte[] sourceData = IOUtils.toByteArray((InputStream)inputStream);
            SealResultInfo sealResultInfo = SealSignatureUtil.signKeyword(sourceData, appearance, signInfo, keyword, replaceSpace);
            byte[] signedData = sealResultInfo.getSignedPDFData();
            IOUtils.write((byte[])signedData, (OutputStream)outputStream);
            businessLog.info("signKeyword end...");
            SealResultInfo sealResultInfo2 = sealResultInfo;
            return sealResultInfo2;
        }
        catch (IOException e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        catch (Exception e) {
            businessLog.error("signKeyword:", (Throwable)e);
            throw new SealException("signKeyword failed:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            businessLog.info("signKeyword: in and out stream closed.");
            MethodCostTimeUtil.recordEndTime(methodName);
        }
    }

    public static SealResultInfo signCrossPage(InputStream inputStream, OutputStream outputStream, GraphicAppearance appearance, SignInfoConfig signInfo) throws SealException {
        businessLog.info("signCrossPage begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signCrossPage");
        try {
            if (null == inputStream) {
                throw new SealException("inputStream is null!");
            }
            if (null == outputStream) {
                throw new SealException("outputStream is null!");
            }
            byte[] sourceData = IOUtils.toByteArray((InputStream)inputStream);
            SealResultInfo sealResultInfo = SealSignatureUtil.signCrossPage(sourceData, appearance, signInfo);
            byte[] signedData = sealResultInfo.getSignedPDFData();
            IOUtils.write((byte[])signedData, (OutputStream)outputStream);
            businessLog.info("signCrossPage end...");
            SealResultInfo sealResultInfo2 = sealResultInfo;
            return sealResultInfo2;
        }
        catch (IOException e) {
            businessLog.error("signCrossPage:", (Throwable)e);
            throw new SealException("signCrossPage failed:", e);
        }
        catch (Exception e) {
            businessLog.error("signCrossPage:", (Throwable)e);
            throw new SealException("signCrossPage failed:", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            businessLog.info("signCrossPage: in and out stream closed.");
            MethodCostTimeUtil.recordEndTime(methodName);
        }
    }

    public static SealResultInfo createBlankSignature(InputStream inputStream, OutputStream outputStream, AbstractAppearance appearance, SignInfoConfig signatureConfig) throws SealException {
        businessLog.info("createBlankSignature begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("createBlankSignature");
        ParamsCheckUtil.checkSignParams(inputStream, outputStream, appearance, signatureConfig);
        try {
            SealResultInfo result = null;
            if (appearance instanceof GraphicAppearance) {
                result = SealSignatureUtil.signGraphic(inputStream, outputStream, (GraphicAppearance)appearance, signatureConfig);
            } else if (appearance instanceof BlankAppearance) {
                result = SealSignatureUtil.signBlank(inputStream, outputStream, (BlankAppearance)appearance, signatureConfig);
            } else if (appearance instanceof TextAppearance) {
                result = SealSignatureUtil.signText(inputStream, outputStream, (TextAppearance)appearance, signatureConfig);
            }
            SealResultInfo sealResultInfo = result;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("createBlankSignature: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearance, e});
            throw e;
        }
        catch (Exception e) {
            businessLog.error("createBlankSignature: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearance, e});
            throw new SealException("createBlankSignature failed:", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("createBlankSignature end...");
        }
    }

    public static SealResultInfo signCoordinates(InputStream input, OutputStream output, List<AbstractAppearance> appearanceList, SignInfoConfig signatureConfig) throws SealException {
        AbstractAppearance tmpAppearance;
        int i;
        businessLog.info("signCoordinates begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("signCoordinates");
        ParamsCheckUtil.checkSignParams(input, output, appearanceList, signatureConfig);
        int size = appearanceList.size();
        AbstractAppearance firstAppearance = appearanceList.get(0);
        if (firstAppearance instanceof TextAppearance) {
            for (i = 1; i < size; ++i) {
                tmpAppearance = appearanceList.get(i);
                if (tmpAppearance instanceof TextAppearance) continue;
                throw new SealException("appearanceList must contain the same type!");
            }
        } else if (firstAppearance instanceof GraphicAppearance) {
            for (i = 1; i < size; ++i) {
                tmpAppearance = appearanceList.get(i);
                if (tmpAppearance instanceof GraphicAppearance) continue;
                throw new SealException("appearanceList must contain the same type!");
            }
        } else {
            throw new SealException("appearanceList contains unsupported type!");
        }
        try {
            SealResultInfo result = null;
            if (firstAppearance instanceof GraphicAppearance) {
                result = SealSignatureUtil.signGraphic(input, output, appearanceList, signatureConfig);
            } else if (firstAppearance instanceof TextAppearance) {
                result = SealSignatureUtil.signText(input, output, appearanceList, signatureConfig);
            } else {
                throw new SealException("unsupport appearance type!");
            }
            SealResultInfo sealResultInfo = result;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("signCoordinates: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearanceList, e});
            throw e;
        }
        catch (Exception e) {
            businessLog.error("signCoordinates: signatureConfig info:{}\n appearance info:{}", new Object[]{signatureConfig, appearanceList, e});
            throw new SealException("signCoordinates failed:", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("signCoordinates end...");
        }
    }

    public static SealResultInfo combineExternalP7Signature(byte[] sourceData, GraphicAppearance appearance, AbstractExternalP7Signer p7Signer) throws SealException {
        businessLog.info("combineExternalP7Signature begin...");
        ParamsCheckUtil.checkSignParams(sourceData, appearance);
        PDFUtil.checkLength(sourceData.length);
        PdfReader reader = null;
        try {
            reader = new PdfReader(sourceData);
            ByteArrayOutputStream os = new ByteArrayOutputStream(8192);
            SealResultInfo resultInfo = AsyncSignatureUtil.combineExternalP7Signature(reader, (OutputStream)os, (AbstractAppearance)appearance, p7Signer);
            resultInfo.setSignedPDFData(os.toByteArray());
            SealResultInfo sealResultInfo = resultInfo;
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw new SealException("combineExternalP7Signature failed", e);
        }
        finally {
            businessLog.info("combineExternalP7Signature end...");
        }
    }

    public static SealResultInfo combineExternalP7Signature(InputStream inputStream, OutputStream outputStream, AbstractAppearance appearance, AbstractExternalP7Signer p7Signer) throws SealException {
        businessLog.info("combineExternalP7Signature begin...");
        ParamsCheckUtil.checkSignParams(inputStream, outputStream, appearance);
        PdfReader reader = null;
        try {
            reader = new PdfReader(inputStream);
            SealResultInfo sealResultInfo = AsyncSignatureUtil.combineExternalP7Signature(reader, outputStream, appearance, p7Signer);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw new SealException("combineExternalP7Signature failed", e);
        }
        finally {
            businessLog.info("combineExternalP7Signature end...");
        }
    }

    public static SealResultInfo combineExternalP7Signature(InputStream inputStream, OutputStream outputStream, List<AbstractAppearance> appearanceList, AbstractExternalP7Signer p7Signer) throws SealException {
        businessLog.info("combineExternalP7Signature begin...");
        int size = appearanceList.size();
        AbstractAppearance appearance = appearanceList.get(size - 1);
        ParamsCheckUtil.checkSignParams(inputStream, outputStream, appearance);
        PdfReader reader = null;
        try {
            byte[] openPassword;
            reader = new PdfReader(inputStream);
            SignInfoConfig signatureConfig = p7Signer.getSignInfoConfig();
            if (null != signatureConfig && null != (openPassword = signatureConfig.getOpenPassword())) {
                reader.setOpenPassword(openPassword);
            }
            SealResultInfo sealResultInfo = AsyncSignatureUtil.combineExternalP7Signature(reader, outputStream, appearance, p7Signer);
            return sealResultInfo;
        }
        catch (SealException e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("combineExternalP7Signature failed", (Throwable)e);
            throw new SealException("combineExternalP7Signature failed", e);
        }
        finally {
            businessLog.info("combineExternalP7Signature end...");
        }
    }

    private static SealResultInfo combineExternalP7Signature(PdfReader reader, OutputStream outputStream, AbstractAppearance appearance, AbstractExternalP7Signer p7Signer) throws SealException {
        SealResultInfo resultInfo = new SealResultInfo();
        String methodName = MethodCostTimeUtil.recordStartTime("combineExternalP7Signature");
        if (null == p7Signer) {
            throw new SealException("p7Signer is null");
        }
        PdfDocument pdfDoc = null;
        try {
            byte[] openPassword;
            SignInfoConfig signatureConfig = p7Signer.getSignInfoConfig();
            if (null != signatureConfig && null != (openPassword = signatureConfig.getOpenPassword())) {
                reader.setOpenPassword(openPassword);
            }
            pdfDoc = new PdfDocument(reader);
            PDFUtil.checkLength(reader.getFileLength());
            ParamsCheckUtil.checkPrimaryParam(pdfDoc, appearance, false);
            String signFieldName = appearance.getSignFieldName();
            PdfSigner.signDeferred(pdfDoc, signFieldName, outputStream, p7Signer);
            resultInfo.setSignFieldName(signFieldName);
            resultInfo.setSignStatus(true);
        }
        catch (SealException e) {
            businessLog.error("combineExternalP7Signature: \n appearance info:{}", (Object)appearance, (Object)e);
            resultInfo.setSignStatus(false);
            resultInfo.setFailReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            businessLog.error("combineExternalP7Signature: \n appearance info:{}", (Object)appearance, (Object)e);
            resultInfo.setSignStatus(false);
            resultInfo.setFailReason(e.getMessage());
            throw new SealException("combineExternalSignature:", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodName);
        }
        return resultInfo;
    }
}

