/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.pdf;

import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.ExceptionConverter;
import cfca.com.itextpdf.text.io.IndependentRandomAccessSource;
import cfca.com.itextpdf.text.io.RandomAccessSource;
import cfca.com.itextpdf.text.io.RandomAccessSourceFactory;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class RandomAccessFileOrArray
implements DataInput {
    private final RandomAccessSource byteSource;
    private long byteSourcePosition;
    private byte back;
    private boolean isBack = false;

    @Deprecated
    public RandomAccessFileOrArray(String filename) throws IOException {
        this(new RandomAccessSourceFactory().setForceRead(false).setUsePlainRandomAccess(Document.plainRandomAccess).createBestSource(filename));
    }

    @Deprecated
    public RandomAccessFileOrArray(RandomAccessFileOrArray source) {
        this(new IndependentRandomAccessSource(source.byteSource));
    }

    public RandomAccessFileOrArray createView() {
        return new RandomAccessFileOrArray(new IndependentRandomAccessSource(this.byteSource));
    }

    public RandomAccessSource createSourceView() {
        return new IndependentRandomAccessSource(this.byteSource);
    }

    public RandomAccessFileOrArray(RandomAccessSource byteSource) {
        this.byteSource = byteSource;
    }

    @Deprecated
    public RandomAccessFileOrArray(String filename, boolean forceRead, boolean plainRandomAccess) throws IOException {
        this(new RandomAccessSourceFactory().setForceRead(forceRead).setUsePlainRandomAccess(plainRandomAccess).createBestSource(filename));
    }

    @Deprecated
    public RandomAccessFileOrArray(URL url) throws IOException {
        this(new RandomAccessSourceFactory().createSource(url));
    }

    @Deprecated
    public RandomAccessFileOrArray(InputStream is) throws IOException {
        this(new RandomAccessSourceFactory().createSource(is));
    }

    @Deprecated
    public RandomAccessFileOrArray(byte[] arrayIn) {
        this(new RandomAccessSourceFactory().createSource(arrayIn));
    }

    @Deprecated
    protected RandomAccessSource getByteSource() {
        return this.byteSource;
    }

    public void pushBack(byte b) {
        this.back = b;
        this.isBack = true;
    }

    public int read() throws IOException {
        if (this.isBack) {
            this.isBack = false;
            return this.back & 0xFF;
        }
        return this.byteSource.get(this.byteSourcePosition++);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int byteSourceCount;
        if (len == 0) {
            return 0;
        }
        int count = 0;
        if (this.isBack && len > 0) {
            this.isBack = false;
            b[off++] = this.back;
            --len;
            ++count;
        }
        if (len > 0 && (byteSourceCount = this.byteSource.get(this.byteSourcePosition, b, off, len)) > 0) {
            count += byteSourceCount;
            this.byteSourcePosition += (long)byteSourceCount;
        }
        if (count == 0) {
            return -1;
        }
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public long skip(long n) throws IOException {
        long len;
        long pos;
        long newpos;
        if (n <= 0L) {
            return 0L;
        }
        int adj = 0;
        if (this.isBack) {
            this.isBack = false;
            if (n == 1L) {
                return 1L;
            }
            --n;
            adj = 1;
        }
        if ((newpos = (pos = this.getFilePointer()) + n) > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return newpos - pos + (long)adj;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Deprecated
    public void reOpen() throws IOException {
        this.seek(0L);
    }

    public void close() throws IOException {
        this.isBack = false;
        this.byteSource.close();
    }

    public long length() throws IOException {
        return this.byteSource.length();
    }

    public void seek(long pos) throws IOException {
        this.byteSourcePosition = pos;
        this.isBack = false;
    }

    public long getFilePointer() throws IOException {
        return this.byteSourcePosition - (long)(this.isBack ? 1 : 0);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    public final short readShortLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    public final int readUnsignedShortLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch2 << 8) + (ch1 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    public final char readCharLE() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch2 << 8) + (ch1 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public final int readIntLE() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public final long readUnsignedInt() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.read();
        if ((ch1 | (ch2 = (long)this.read()) | (ch3 = (long)this.read()) | (ch4 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public final long readUnsignedIntLE() throws IOException {
        long ch4;
        long ch3;
        long ch2;
        long ch1 = this.read();
        if ((ch1 | (ch2 = (long)this.read()) | (ch3 = (long)this.read()) | (ch4 = (long)this.read())) < 0L) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final long readLongLE() throws IOException {
        int i1 = this.readIntLE();
        int i2 = this.readIntLE();
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final float readFloatLE() throws IOException {
        return Float.intBitsToFloat(this.readIntLE());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final double readDoubleLE() throws IOException {
        return Double.longBitsToDouble(this.readLongLE());
    }

    public String readLine() throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readString(int length, String encoding) throws IOException {
        byte[] buf = new byte[length];
        this.readFully(buf);
        try {
            return new String(buf, encoding);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

