/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.formfield;

import cfca.com.itextpdf.text.BaseColor;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.error_messages.MessageLocalization;
import cfca.com.itextpdf.text.pdf.BaseFont;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.PdfAnnotation;
import cfca.com.itextpdf.text.pdf.PdfContentByte;
import cfca.com.itextpdf.text.pdf.PdfFormField;
import cfca.com.itextpdf.text.pdf.PdfGState;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.PdfStamperImp;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PdfFormFieldAppearance {
    private PdfStamperImp writer;
    private ByteBuffer ffout;
    private File tempFile;
    private OutputStream originalout;
    private PdfStamper stamper;
    private boolean preClosed = false;
    private List<FormFieldItem> formFields = new ArrayList<FormFieldItem>();
    private List<StaticTextItem> staticTexts = new ArrayList<StaticTextItem>();

    public PdfFormFieldAppearance(PdfStamperImp writer) {
        this.writer = writer;
    }

    public void setFFout(ByteBuffer ffout) {
        this.ffout = ffout;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public void setOriginalout(OutputStream os) {
        this.originalout = os;
    }

    public void setStamper(PdfStamper stamper) {
        this.stamper = stamper;
    }

    public void preClose() throws IOException, DocumentException {
        Object item;
        int i;
        if (this.preClosed) {
            throw new DocumentException(MessageLocalization.getComposedMessage("document.already.pre.closed", new Object[0]));
        }
        this.stamper.mergeVerification();
        this.preClosed = true;
        int size = this.formFields.size();
        for (i = 0; i < size; ++i) {
            item = this.formFields.get(i);
            PdfFormField pdfFormField = ((FormFieldItem)item).getFormField();
            int page = ((FormFieldItem)item).getPage();
            this.writer.addAnnotation((PdfAnnotation)pdfFormField, page);
        }
        size = this.staticTexts.size();
        for (i = 0; i < size; ++i) {
            item = this.staticTexts.get(i);
            PdfContentByte content = this.stamper.getOverContent(((StaticTextItem)item).getPage());
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(1.0f);
            gs.setStrokeOpacity(1.0f);
            content.saveState();
            content.setGState(gs);
            content.beginText();
            content.setColorFill(((StaticTextItem)item).getBaseColor());
            content.setFontAndSize(((StaticTextItem)item).getBaseFont(), ((StaticTextItem)item).getFontSize());
            content.showTextAligned(((StaticTextItem)item).getAlign(), ((StaticTextItem)item).getText(), ((StaticTextItem)item).getX(), ((StaticTextItem)item).getY(), 0.0f);
            content.endText();
        }
        this.writer.close(this.stamper.getMoreInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        byte[] ffBytes = this.ffout.getBuffer();
        try {
            this.originalout.write(ffBytes, 0, ffBytes.length);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (this.originalout != null) {
                    this.originalout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writer.reader.close();
        }
    }

    public boolean addFormField(int page, PdfFormField formField) {
        return this.formFields.add(new FormFieldItem(page, formField));
    }

    public void clearFormField() {
        this.formFields.clear();
    }

    public boolean addStaticText(int page, float x, float y, int align, String text, BaseFont baseFont, BaseColor baseColor, int fontSize) {
        return this.staticTexts.add(new StaticTextItem(page, x, y, align, text, baseFont, baseColor, fontSize));
    }

    public void clearStaticText() {
        this.staticTexts.clear();
    }

    class FormFieldItem {
        private PdfFormField formField;
        private int page;

        public FormFieldItem(int page, PdfFormField formField) {
            this.formField = formField;
            this.page = page;
        }

        public int getPage() {
            return this.page;
        }

        public PdfFormField getFormField() {
            return this.formField;
        }
    }

    class StaticTextItem {
        private int fontSize;
        private BaseFont baseFont;
        private BaseColor baseColor;
        private String text;
        private int align;
        private float y;
        private float x;
        private int page;

        public int getFontSize() {
            return this.fontSize;
        }

        public BaseFont getBaseFont() {
            return this.baseFont;
        }

        public BaseColor getBaseColor() {
            return this.baseColor;
        }

        public String getText() {
            return this.text;
        }

        public int getAlign() {
            return this.align;
        }

        public float getY() {
            return this.y;
        }

        public float getX() {
            return this.x;
        }

        public int getPage() {
            return this.page;
        }

        public StaticTextItem(int page, float x, float y, int align, String text, BaseFont baseFont, BaseColor baseColor, int fontSize) {
            this.page = page;
            this.x = x;
            this.y = y;
            this.align = align;
            this.text = text;
            this.baseFont = baseFont;
            this.baseColor = baseColor;
            this.fontSize = fontSize;
        }
    }
}

