/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.PaperlessHttpClientConnectionOperator;
import cfca.paperless.base.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String contentType = "application/x-www-form-urlencoded";
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int DEFAULT_READ_TIMEOUT = 600000;

    public static byte[] doGet(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(HttpClientUtil.createHttpClientConnectionManager()).build();
        return HttpClientUtil.sendAndGetResponse(httpClient, (HttpRequestBase)httpGet, headers, null, connectTimeout, readTimeout);
    }

    public static byte[] doPost(String url, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtil.packageParam((HttpEntityEnclosingRequestBase)httpPost, params);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(HttpClientUtil.createHttpClientConnectionManager()).build();
        return HttpClientUtil.sendAndGetResponse(httpClient, (HttpRequestBase)httpPost, headers, params, connectTimeout, readTimeout);
    }

    public static byte[] doPost(String url, byte[] parameterData, Map<String, String> headers, int connectTimeout, int readTimeout) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(parameterData));
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(HttpClientUtil.createHttpClientConnectionManager()).build();
        return HttpClientUtil.sendAndGetResponse(httpClient, (HttpRequestBase)httpPost, headers, null, connectTimeout, readTimeout);
    }

    public static byte[] doPost(String url, String parameterStr, Map<String, String> headers, int connectTimeout, int readTimeout) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(parameterStr));
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(HttpClientUtil.createHttpClientConnectionManager()).build();
        return HttpClientUtil.sendAndGetResponse(httpClient, (HttpRequestBase)httpPost, headers, null, connectTimeout, readTimeout);
    }

    public static byte[] sendAndGetResponse(CloseableHttpClient closeableHttpClient, HttpRequestBase httpMethod, Map<String, String> headers, Map<String, String> params, int connectTimeout, int readTimeout) throws CodeException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(readTimeout).build();
        httpMethod.setConfig(requestConfig);
        HttpClientUtil.packageHeader(httpMethod, headers);
        CloseableHttpResponse httpResponse = null;
        Object result = null;
        try {
            HttpEntity httpEntity;
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpMethod);
            if (httpResponse != null && httpResponse.getStatusLine() != null && (httpEntity = httpResponse.getEntity()) != null) {
                result = EntityUtils.toByteArray((HttpEntity)httpEntity);
            }
            httpEntity = result;
            return httpEntity;
        }
        catch (Exception e) {
            logger.error("HttpClientUtil send url({}) request fail:", (Object)httpMethod.getURI().toString());
            logger.error("HttpClientUtil header info:{}", (Object)StringUtil.mapToStr(headers));
            logger.error("HttpClientUtil params info:{}", (Object)StringUtil.mapToStr(params));
            throw new CodeException("600305", httpMethod.getURI().toString(), (Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException iOException) {}
            }
            if (closeableHttpClient != null) {
                try {
                    closeableHttpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void packageHeader(HttpRequestBase httpMethod, Map<String, String> params) {
        if (params == null) {
            params = HttpClientUtil.getDefaultHttpHeaders();
        }
        Set<Map.Entry<String, String>> entrySet = params.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            httpMethod.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private static void packageParam(HttpEntityEnclosingRequestBase httpMethod, Map<String, String> params) throws UnsupportedEncodingException {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
    }

    public static HashMap<String, String> getDefaultHttpHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", "utf-8");
        headers.put("Content-Type", contentType);
        headers.put("Connection", "Close");
        return headers;
    }

    private static HttpClientConnectionManager createHttpClientConnectionManager() {
        PaperlessHttpClientConnectionOperator connectionOperator = new PaperlessHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build(), null, null);
        return new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)connectionOperator, null, -1L, TimeUnit.MILLISECONDS);
    }
}

