/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.signer;

import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.lib.crypto.hard.format.HashLengths;
import cfca.sadk.lib.crypto.hard.generator.InternalPrivateKey;
import cfca.sadk.lib.crypto.hard.signer.AbsSigner;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.Cipher;

public final class RSASigner
extends AbsSigner {
    public RSASigner(Provider provider, String mType, boolean asn1Format) throws Exception {
        super(provider, mType, asn1Format);
    }

    PrivateKey formatPrivateKey(PrivateKey privateKey) throws Exception {
        PrivateKey jceKey = null;
        jceKey = privateKey instanceof InternalPrivateKey ? ((InternalPrivateKey)privateKey).getInternalPrivateKey() : privateKey;
        return jceKey;
    }

    PublicKey formatPublicKey(PublicKey publicKey) throws Exception {
        return publicKey;
    }

    byte[] formatInputSignValue(byte[] input) throws Exception {
        return input;
    }

    byte[] formatOutputSignValue(byte[] output) throws Exception {
        return output;
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
        cipher.init(1, this.formatPrivateKey(privateKey));
        byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(this.mType, hashValue);
        return cipher.doFinal(hashWithAlgorithm);
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signData) throws Exception {
        HashLengths.checkHashLength(this.mType, hashValue);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING", this.provider);
        cipher.init(2, this.formatPublicKey(publicKey));
        byte[] decryptHash = cipher.doFinal(signData);
        byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(this.mType, hashValue);
        return RSAPackageUtil.isRSAHashEqual(decryptHash, hashWithAlgorithm);
    }

    public int setEccLength(PrivateKey privateKey) throws Exception {
        return 0;
    }
}

