/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import java.io.RandomAccessFile;

final class CRLTag {
    final int begin;
    final int end;
    final int length;
    final String name;

    CRLTag(int begin, int length, String name) {
        this.begin = begin;
        this.length = length;
        this.end = begin + length;
        this.name = name;
    }

    void checkLengths(long fileLength) throws PKIException {
        if ((long)this.begin > fileLength) {
            throw new PKIException("checkLengths failure when invalid " + this.name + "Begin --> " + this.begin);
        }
        if ((long)this.length > fileLength) {
            throw new PKIException("checkLengths failure when invalid " + this.name + "Length --> " + this.length);
        }
        if ((long)this.end > fileLength) {
            throw new PKIException("checkLengths failure when invalid " + this.name + "End --> " + this.end);
        }
    }

    byte[] valueFrom(RandomAccessFile file, int position, int maxLength) throws PKIException {
        try {
            file.seek(position);
            if (this.length > maxLength) {
                throw new PKIException("checkLengths failure when invalid " + this.name + "Length[m]--> " + this.length);
            }
            byte[] value = new byte[this.length];
            int remain = value.length;
            int length = 0;
            while ((length = file.read(value, 0, remain)) > 0 && (remain -= length) > 0) {
            }
            if (length != value.length) {
                throw new PKIException("checkLengths failure when invalid " + this.name + "Length[r]--> " + length);
            }
            return value;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("checkLengths failure when reading" + this.name + "Lengths", e);
        }
    }

    byte[] valueFrom(byte[] encoding) {
        byte[] value = new byte[this.length];
        System.arraycopy(encoding, this.begin, value, 0, value.length);
        return value;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("[begin=");
        builder.append(this.begin);
        builder.append(", end=");
        builder.append(this.end);
        builder.append(", length=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }
}

