/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.layout.border;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.geom.Point;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import cfca.sadk.com.itextpdf.layout.border.Border;

public class SolidBorder
extends Border {
    public SolidBorder(float width) {
        super(width);
    }

    public SolidBorder(Color color, float width) {
        super(color, width);
    }

    public SolidBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo(x1, y1).lineTo(x2, y2).lineTo(x3, y3).lineTo(x4, y4).lineTo(x1, y1).fill().restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float outerRadius, Border.Side side, float borderWidthBefore, float borderWidthAfter) {
        float innerRadiusBefore = Math.max(0.0f, outerRadius - borderWidthBefore);
        float innerRadius = Math.max(0.0f, outerRadius - this.width);
        float innerRadiusAfter = Math.max(0.0f, outerRadius - borderWidthAfter);
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, side);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                if (innerRadiusBefore > innerRadius) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x4, y1 - innerRadius), new Point(x1 + innerRadiusBefore, y1 - innerRadius)).getX();
                    y1 -= innerRadius;
                } else {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 + innerRadiusBefore, y1), new Point(x1 + innerRadiusBefore, y1 - innerRadius)).getY();
                    x1 += innerRadiusBefore;
                }
                if (innerRadiusAfter > innerRadius) {
                    x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 - innerRadius), new Point(x2 - innerRadiusAfter, y2 - innerRadius)).getX();
                    y2 -= innerRadius;
                    break;
                }
                y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 - innerRadiusAfter, y2), new Point(x2 - innerRadiusAfter, y2 - innerRadius)).getY();
                x2 -= innerRadiusAfter;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                if (innerRadius > innerRadiusBefore) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 - innerRadiusBefore), new Point(x1 - innerRadius, y1 - innerRadiusBefore)).getX();
                    y1 -= innerRadiusBefore;
                } else {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 - innerRadius, y1), new Point(x1 - innerRadius, y1 - innerRadiusBefore)).getY();
                    x1 -= innerRadius;
                }
                if (innerRadiusAfter > innerRadius) {
                    y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 - innerRadius, y2), new Point(x2 - innerRadius, y2 + innerRadiusAfter)).getY();
                    x2 -= innerRadius;
                    break;
                }
                x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 + innerRadiusAfter), new Point(x2 - innerRadius, y2 + innerRadiusAfter)).getX();
                y2 += innerRadiusAfter;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                if (innerRadius > innerRadiusBefore) {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 - innerRadiusBefore, y1), new Point(x1 - innerRadiusBefore, y1 + innerRadius)).getY();
                    x1 -= innerRadiusBefore;
                } else {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 + innerRadius), new Point(x1 - innerRadiusBefore, y1 + innerRadius)).getX();
                    y1 += innerRadius;
                }
                if (innerRadiusAfter > innerRadius) {
                    x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 + innerRadius), new Point(x2 + innerRadiusAfter, y2 + innerRadius)).getX();
                    y2 += innerRadius;
                    break;
                }
                y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 + innerRadiusAfter, y2), new Point(x2 + innerRadiusAfter, y2 + innerRadius)).getY();
                x2 += innerRadiusAfter;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
                if (innerRadius > innerRadiusBefore) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 + innerRadiusBefore), new Point(x1 + innerRadius, y1 + innerRadiusBefore)).getX();
                    y1 += innerRadiusBefore;
                } else {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 + innerRadius, y1), new Point(x1 + innerRadius, y1 + innerRadiusBefore)).getY();
                    x1 += innerRadius;
                }
                if (innerRadiusAfter > innerRadius) {
                    y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 + innerRadius, y2), new Point(x2 + innerRadius, y2 - innerRadiusAfter)).getY();
                    x2 += innerRadius;
                    break;
                }
                x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 - innerRadiusAfter), new Point(x2 + innerRadius, y2 - innerRadiusAfter)).getX();
                y2 -= innerRadiusAfter;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo(x1, y1).lineTo(x2, y2).lineTo(x3, y3).lineTo(x4, y4).lineTo(x1, y1).fill().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).moveTo(x1, y1).lineTo(x2, y2).stroke().restoreState();
    }
}

