/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.ImageUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.UpdateSealUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutPictureUtil {
    private static final Logger log = LoggerFactory.getLogger(OutPictureUtil.class);

    private static BufferedImage bufferedImageUtil(String message, String messageFont, String centerName, String centFont, int centFontSize, int centtopdown, int centleftright, String bottomName, String btFont, int bttopdown, int btleftright, String bottomName1, String bt1Font, int bt1topdown, int bt1leftright, int width, int height, int fontSize, String path) throws FileNotFoundException, IOException {
        BufferedImage image = null;
        if (message != null) {
            int centerX = 260;
            int centerY = 260;
            int radius = 230;
            image = ImageIO.read(new FileInputStream(path));
            Graphics2D g2 = image.createGraphics();
            g2.setColor(Color.RED);
            g2.setFont(new Font(centFont, 1, centFontSize));
            if (StringUtil.isNotEmpty((String)centerName)) {
                g2.drawString(centerName, width + centleftright, height + centtopdown);
            }
            g2.setFont(new Font(btFont, 1, 20));
            if (bottomName != null) {
                g2.drawString(bottomName, width + 35 + btleftright, height + 20 + bttopdown);
            }
            g2.setFont(new Font(bt1Font, 1, 15));
            if (bottomName1 != null) {
                g2.drawString(bottomName1, width + 45 + bt1leftright, height + 35 + bt1topdown);
            }
            String[] messages = StringUtil.toStringItemArray((String)message);
            int ilength = messages.length;
            Font f = new Font(messageFont, 1, fontSize);
            FontRenderContext context = g2.getFontRenderContext();
            Rectangle2D bounds = f.getStringBounds(message, context);
            double charInterval = bounds.getWidth() / (double)ilength;
            double ascent = -bounds.getY();
            int first = 0;
            int second = 0;
            boolean odd = false;
            if (ilength % 2 == 1) {
                first = (ilength - 1) / 2;
                odd = true;
            } else {
                first = ilength / 2 - 1;
                second = ilength / 2;
                odd = false;
            }
            double radius2 = 230.0 - ascent;
            double x0 = 260.0;
            double y0 = 30.0 + ascent;
            double a = 2.0 * Math.asin(charInterval / (2.0 * radius2));
            if (odd) {
                Font f2;
                AffineTransform transform;
                double ay;
                double ax;
                double aa;
                int i;
                g2.setFont(f);
                g2.drawString(messages[first], (float)(x0 - charInterval / 2.0), (float)y0);
                for (i = first + 1; i < ilength; ++i) {
                    aa = (double)(i - first) * a;
                    ax = radius2 * Math.sin(aa);
                    ay = radius2 - radius2 * Math.cos(aa);
                    transform = AffineTransform.getRotateInstance(aa);
                    f2 = f.deriveFont(transform);
                    g2.setFont(f2);
                    g2.drawString(messages[i], (float)(x0 + ax - charInterval / 2.0 * Math.cos(aa)), (float)(y0 + ay - charInterval / 2.0 * Math.sin(aa)));
                }
                for (i = first - 1; i > -1; --i) {
                    aa = (double)(first - i) * a;
                    ax = radius2 * Math.sin(aa);
                    ay = radius2 - radius2 * Math.cos(aa);
                    transform = AffineTransform.getRotateInstance(-aa);
                    f2 = f.deriveFont(transform);
                    g2.setFont(f2);
                    g2.drawString(messages[i], (float)(x0 - ax - charInterval / 2.0 * Math.cos(aa)), (float)(y0 + ay + charInterval / 2.0 * Math.sin(aa)));
                }
            } else {
                Font f2;
                AffineTransform transform;
                double ay;
                double ax;
                double aa;
                int i;
                for (i = second; i < ilength; ++i) {
                    aa = ((double)(i - second) + 0.5) * a;
                    ax = radius2 * Math.sin(aa);
                    ay = radius2 - radius2 * Math.cos(aa);
                    transform = AffineTransform.getRotateInstance(aa);
                    f2 = f.deriveFont(transform);
                    g2.setFont(f2);
                    g2.drawString(messages[i], (float)(x0 + ax - charInterval / 2.0 * Math.cos(aa)), (float)(y0 + ay - charInterval / 2.0 * Math.sin(aa)));
                }
                for (i = first; i > -1; --i) {
                    aa = ((double)(first - i) + 0.5) * a;
                    ax = radius2 * Math.sin(aa);
                    ay = radius2 - radius2 * Math.cos(aa);
                    transform = AffineTransform.getRotateInstance(-aa);
                    f2 = f.deriveFont(transform);
                    g2.setFont(f2);
                    g2.drawString(messages[i], (float)(x0 - ax - charInterval / 2.0 * Math.cos(aa)), (float)(y0 + ay + charInterval / 2.0 * Math.sin(aa)));
                }
            }
            g2.dispose();
        }
        return image;
    }

    private static byte[] getSquarePng(String message, int width, int height, String fontFamily, int fontSize, int type, String fontColor, boolean border, int dpi) throws CodeException {
        BufferedImage buffImg = null;
        if (message != null) {
            buffImg = new BufferedImage(fontSize * 2, fontSize * 2, 1);
            Graphics2D g2 = buffImg.createGraphics();
            buffImg = g2.getDeviceConfiguration().createCompatibleImage(fontSize * 2, fontSize * 2, 3);
            g2 = buffImg.createGraphics();
            int rColor = Integer.parseInt(fontColor.substring(0, 2), 16);
            int gColor = Integer.parseInt(fontColor.substring(2, 4), 16);
            int bColor = Integer.parseInt(fontColor.substring(4, 6), 16);
            Color color = new Color(rColor, gColor, bColor);
            g2.setColor(color);
            g2.setFont(new Font(fontFamily, 0, fontSize));
            String newMessage = "";
            if (message.length() == 1) {
                newMessage = message + "\u4e4b\u5370\u7ae0";
            } else if (message.length() == 2) {
                newMessage = message + "\u4e4b\u7ae0";
            } else if (message.length() == 3) {
                newMessage = message + "\u7ae0";
            } else if (message.length() > 3) {
                newMessage = message.substring(0, 4);
            }
            char[] charArray = newMessage.toCharArray();
            if (type == 0) {
                g2.drawString(new String(new char[]{charArray[0]}), fontSize, fontSize - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[1]}), fontSize, fontSize * 2 - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[2]}), 0, fontSize - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[3]}), 0, fontSize * 2 - fontSize / 8);
            } else {
                g2.drawString(new String(new char[]{charArray[1]}), fontSize, fontSize - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[3]}), fontSize, fontSize * 2 - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[0]}), 0, fontSize - fontSize / 8);
                g2.drawString(new String(new char[]{charArray[2]}), 0, fontSize * 2 - fontSize / 8);
            }
            if (border) {
                g2.drawRect(0, 0, buffImg.getWidth() - 2, buffImg.getHeight() - 2);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u751f\u6210\u65b9\u5f62\u56fe\u7247\u51fa\u9519", (Throwable)e);
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }

    public static byte[] getNamePngToByte(String name, int hight, int width, int fontSize, String fontColor, String family, boolean border, int dpi) throws CodeException {
        return OutPictureUtil.getSquarePng(name, width, hight, family, fontSize, 0, fontColor, border, dpi);
    }

    public static byte[] getRectanglePng(String message, int width, int height, int fontSize, String fontColor, String fontFamily, boolean border, int dpi) throws CodeException {
        BufferedImage buffImg = null;
        if (message != null) {
            String[] msg = message.split("##");
            int maxLength = msg[0].length();
            for (int i = 0; i < msg.length; ++i) {
                if (msg[i].length() <= maxLength) continue;
                maxLength = msg[i].length();
            }
            buffImg = new BufferedImage(maxLength * fontSize + maxLength * 2, msg.length * fontSize, 1);
            Graphics2D g2 = buffImg.createGraphics();
            buffImg = g2.getDeviceConfiguration().createCompatibleImage(maxLength * fontSize + maxLength * 2, msg.length * fontSize, 3);
            g2 = buffImg.createGraphics();
            int rColor = Integer.parseInt(fontColor.substring(0, 2), 16);
            int gColor = Integer.parseInt(fontColor.substring(2, 4), 16);
            int bColor = Integer.parseInt(fontColor.substring(4, 6), 16);
            Color color = new Color(rColor, gColor, bColor);
            g2.setColor(color);
            g2.setFont(new Font(fontFamily, 0, fontSize));
            for (int j = 0; j < msg.length; ++j) {
                char[] charArray = msg[j].toCharArray();
                long lengthPerChar = maxLength * fontSize / msg[j].length();
                for (int i = 0; i < msg[j].length(); ++i) {
                    g2.drawString(new String(new char[]{charArray[i]}), (float)((long)(2 + fontSize * i) + (long)i * (lengthPerChar - (long)fontSize) * 3L / 2L), (float)(fontSize - fontSize / 8 + fontSize * j));
                }
            }
            if (border) {
                g2.drawRect(0, 0, buffImg.getWidth() - 2, buffImg.getHeight() - 2);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }

    public static byte[] getCirclePngToByte(String imageName, String family, String imageName2, String centFont, int centFontSize, int imageName2Height, int imageName2Width, int height, int width, int fontSize, String path, int dpi) throws CodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage buffImg = null;
        try {
            buffImg = OutPictureUtil.bufferedImageUtil(imageName, family, imageName2, StringUtil.isEmpty((String)centFont) ? "\u5b8b\u4f53" : centFont, centFontSize, imageName2Height, imageName2Width, null, "\u5b8b\u4f53", 0, 0, null, "\u5b8b\u4f53", 0, 0, 180, 380, fontSize, path);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }

    public static byte[] getCirclePngToByte(String imageName, String family, String imageName2, String centFont, int centFontSize, int imageName2Height, int imageName2Width, int height, int width, int fontSize, String businessCode, String bcFontFamily, float bcFontSize, float ratioX, float ratioY, String path, int dpi) throws CodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage buffImg = null;
        try {
            buffImg = OutPictureUtil.bufferedImageUtil(imageName, family, imageName2, StringUtil.isEmpty((String)centFont) ? "\u5b8b\u4f53" : centFont, centFontSize, imageName2Height, imageName2Width, null, "\u5b8b\u4f53", 0, 0, null, "\u5b8b\u4f53", 0, 0, 180, 380, fontSize, path);
            UpdateSealUtil.addBusinessCodeToSealImage((BufferedImage)buffImg, (String)businessCode, (String)bcFontFamily, (float)bcFontSize, (float)ratioX, (float)ratioY);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }

    public static byte[] getCircleStarPngToByte(String imageName, String family, String imageName2, String centFont, int centFontSize, int imageName2Height, int imageName2Width, int height, int width, int fontSize, String path, int dpi) throws CodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage buffImg = null;
        try {
            buffImg = OutPictureUtil.bufferedImageUtil(imageName, family, imageName2, StringUtil.isEmpty((String)centFont) ? "\u5b8b\u4f53" : centFont, centFontSize, imageName2Height, imageName2Width, null, "\u5b8b\u4f53", 0, 0, null, "\u5b8b\u4f53", 0, 0, 180, 380, fontSize, path);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }

    public static byte[] getCircleStarPngToByte(String imageName, String family, String imageName2, String centFont, int centFontSize, int imageName2Height, int imageName2Width, int height, int width, int fontSize, String businessCode, String bcFontFamily, float bcFontSize, float ratioX, float ratioY, String path, int dpi) throws CodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedImage buffImg = null;
        try {
            buffImg = OutPictureUtil.bufferedImageUtil(imageName, family, imageName2, StringUtil.isEmpty((String)centFont) ? "\u5b8b\u4f53" : centFont, centFontSize, imageName2Height, imageName2Width, null, "\u5b8b\u4f53", 0, 0, null, "\u5b8b\u4f53", 0, 0, 180, 380, fontSize, path);
            UpdateSealUtil.addBusinessCodeToSealImage((BufferedImage)buffImg, (String)businessCode, (String)bcFontFamily, (float)bcFontSize, (float)ratioX, (float)ratioY);
            ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        return ImageUtil.resizeImageWithDpi((byte[])byteArrayOutputStream.toByteArray(), (int)width, (int)height, (int)dpi);
    }
}

