/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SES_SignInfo
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1ObjectIdentifier signatureAlgorithm;
    private DERBitString signData;
    private ASN1OctetString cert;

    public static SES_SignInfo getInstance(Object o) {
        if (o instanceof SES_SignInfo) {
            return (SES_SignInfo)((Object)o);
        }
        if (o instanceof ASN1Sequence) {
            return new SES_SignInfo(ASN1Sequence.getInstance((Object)o));
        }
        if (o instanceof DERBitString) {
            return new SES_SignInfo((DERBitString)o);
        }
        return null;
    }

    public SES_SignInfo(ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm, DERBitString signData) {
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signData = signData;
    }

    public SES_SignInfo(DERBitString signData) {
        this.signData = signData;
    }

    public SES_SignInfo(ASN1Sequence instance) {
        Enumeration e = instance.getObjects();
        Object firstElement = e.nextElement();
        if (firstElement instanceof ASN1OctetString) {
            this.cert = ASN1OctetString.getInstance(firstElement);
            this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
            this.signData = DERBitString.getInstance(e.nextElement());
        } else {
            this.signData = DERBitString.getInstance(firstElement);
        }
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignData() {
        return this.signData;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.cert != null && this.signatureAlgorithm != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)this.cert);
            v.add((ASN1Encodable)this.signatureAlgorithm);
            v.add((ASN1Encodable)this.signData);
            return new DERSequence(v);
        }
        return this.signData;
    }
}

