/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.timestamp.client.logging.TscLogging;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.util.Args;

final class TscSubjectName {
    private static final int TYPE_DNS = 2;
    private static final int TYPE_IP = 7;
    private final String value;
    private final int type;

    TscSubjectName(String value, int type) {
        this.value = (String)Args.notNull((Object)value, (String)"Value");
        this.type = Args.positive((int)type, (String)"Type");
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    static List<TscSubjectName> getSubjectAltNames(X509Certificate cert) {
        List<TscSubjectName> subjectNameList = null;
        try {
            Collection<List<?>> alternativeNames = cert.getSubjectAlternativeNames();
            if (alternativeNames == null) {
                subjectNameList = Collections.emptyList();
            } else {
                subjectNameList = new ArrayList();
                for (List<?> alternativeName : alternativeNames) {
                    Integer type = alternativeName.size() >= 2 ? (Integer)alternativeName.get(0) : null;
                    if (type == null || type != 2 && type != 7) continue;
                    Object value = alternativeName.get(1);
                    if (value instanceof String) {
                        subjectNameList.add(new TscSubjectName((String)value, type));
                        continue;
                    }
                    if (!(value instanceof byte[])) continue;
                    TscLogging.ERROR_LOGGER.warn("SubjectAlternativeNames fetch failure: value not string-type, ASN.1 DER encoded form");
                }
            }
        }
        catch (CertificateParsingException ignore) {
            TscLogging.ERROR_LOGGER.warn("SubjectAlternativeNames fetch failure", (Throwable)ignore);
            subjectNameList = Collections.emptyList();
        }
        return subjectNameList;
    }
}

